/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.biomeinjection;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.utils.BiomeSelection;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class Dungeons {
    public static void addDungeons(BiomeLoadingEvent event) {
        if (BiomeSelection.haveCategories(event, Biome.Category.JUNGLE) && RepurposedStructures.RSDungeonsConfig.jungleDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.JUNGLE_DUNGEONS);
        } else if (BiomeSelection.haveCategories(event, Biome.Category.MESA) && RepurposedStructures.RSDungeonsConfig.badlandsDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.BADLANDS_DUNGEONS);
        } else if (BiomeSelection.haveCategories(event, Biome.Category.FOREST) && BiomeSelection.hasName(event, "dark", "spooky", "dead", "haunted") && RepurposedStructures.RSDungeonsConfig.darkForestDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.DARK_FOREST_DUNGEONS);
        } else if (BiomeSelection.haveCategories(event, Biome.Category.DESERT) && RepurposedStructures.RSDungeonsConfig.desertDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.DESERT_DUNGEONS);
        } else if (BiomeSelection.haveCategories(event, Biome.Category.MUSHROOM) && RepurposedStructures.RSDungeonsConfig.mushroomDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            if (RepurposedStructures.RSDungeonsConfig.mushroomDungeonMaxHeight.get() > 62) {
                Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.MUSHROOM_HIGH_DUNGEONS);
            }
            if (RepurposedStructures.RSDungeonsConfig.mushroomDungeonMinHeight.get() <= 62) {
                Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.MUSHROOM_LOW_DUNGEONS);
            }
        } else if (BiomeSelection.haveCategories(event, Biome.Category.SWAMP) && RepurposedStructures.RSDungeonsConfig.swampDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.SWAMP_DUNGEONS);
        } else if (BiomeSelection.haveCategories(event, Biome.Category.ICY) && (BiomeSelection.hasName(event, "icy", "ice", "frozen") || event.getClimate().field_242461_c < 0.0f && !BiomeSelection.hasName(event, "snow")) && RepurposedStructures.RSDungeonsConfig.icyDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.ICY_DUNGEONS);
        } else if (BiomeSelection.haveCategories(event, Biome.Category.ICY) && RepurposedStructures.RSDungeonsConfig.snowDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            Dungeons.replaceOrAddDungeon(true, event, RSConfiguredFeatures.SNOW_DUNGEONS);
        } else if (BiomeSelection.haveCategories(event, Biome.Category.NETHER) && RepurposedStructures.RSDungeonsConfig.netherDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> RSConfiguredFeatures.NETHER_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.endDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.haveCategories(event, Biome.Category.THEEND) && !BiomeSelection.isBiome(event, Biomes.field_76779_k, Biomes.field_201936_P) && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.END_DUNGEONS);
        } else if (BiomeSelection.haveCategories(event, Biome.Category.OCEAN) && RepurposedStructures.RSDungeonsConfig.oceanDungeonAttemptsPerChunk.get() != 0 && Dungeons.dungeonAllowedByNamespaceAndConfig(event)) {
            if (BiomeSelection.hasName(event, "lukewarm") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().field_242461_c >= 0.9f && event.getClimate().field_242461_c < 1.5f) {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_LUKEWARM_DUNGEONS);
            } else if (BiomeSelection.hasName(event, "lukewarm") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().field_242461_c >= 1.5f) {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_WARM_DUNGEONS);
            } else if (BiomeSelection.hasName(event, "cold") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().field_242461_c >= 0.0f && event.getClimate().field_242461_c < 0.5f) {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_COLD_DUNGEONS);
            } else if (BiomeSelection.hasName(event, "frozen", "snow", "ice") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().field_242461_c >= 0.9f && event.getClimate().field_242461_c < 1.5f) {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_FROZEN_DUNGEONS);
            } else {
                Dungeons.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_NEUTRAL_DUNGEONS);
            }
        }
    }

    private static void replaceOrAddDungeon(boolean replacing, BiomeLoadingEvent event, ConfiguredFeature<?, ?> rsDungeon) {
        if (replacing && RepurposedStructures.yungsBetterMineshaftIsNotOn) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(supplier -> ((ConfiguredFeature)supplier.get()).field_222737_a.equals(Features.field_243797_W.field_222737_a));
        }
        event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).add(() -> rsDungeon);
    }

    private static boolean dungeonAllowedByNamespaceAndConfig(BiomeLoadingEvent event) {
        return BiomeSelection.hasNamespace(event, "minecraft") || RepurposedStructures.RSDungeonsConfig.addDungeonsToModdedBiomes.get() != false;
    }
}

