/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class BiomeSelection {
    private static Set<RegistryKey<Biome>> OVERWORLD_BIOMES = new HashSet<RegistryKey<Biome>>();

    public static void setupOverworldBiomesSet() {
        OVERWORLD_BIOMES.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD));
        OVERWORLD_BIOMES.addAll(BiomeManager.getAdditionalOverworldBiomes());
    }

    public static boolean isOverworldBiome(BiomeLoadingEvent event) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        return OVERWORLD_BIOMES.contains(biomeKey);
    }

    public static boolean hasName(BiomeLoadingEvent context, String ... names) {
        return Arrays.stream(names).anyMatch(name -> context.getName().func_110623_a().contains((CharSequence)name));
    }

    public static boolean hasNamespace(BiomeLoadingEvent context, String ... namespace) {
        return Arrays.stream(namespace).anyMatch(name -> context.getName().func_110624_b().contains((CharSequence)name));
    }

    @SafeVarargs
    public static boolean isBiome(BiomeLoadingEvent context, RegistryKey<Biome> ... keys) {
        return Arrays.stream(keys).anyMatch(key -> context.getName().equals((Object)key.func_240901_a_()));
    }

    public static boolean haveCategories(BiomeLoadingEvent context, Biome.Category ... categories) {
        HashSet<Biome.Category> categorySet = new HashSet<Biome.Category>(Arrays.asList(categories));
        return categorySet.contains(context.getCategory());
    }

    public static boolean hasStructure(BiomeLoadingEvent context, Structure<?> structureFeature) {
        return context.getGeneration().getStructures().stream().anyMatch(structureFeatureSupplier -> ((StructureFeature)structureFeatureSupplier.get()).field_236268_b_.equals(structureFeature));
    }

    public static boolean hasStructureType(BiomeLoadingEvent context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().anyMatch(structure -> context.getGeneration().getStructures().stream().anyMatch(structureFeatureSupplier -> ((StructureFeature)structureFeatureSupplier.get()).field_236268_b_.equals(structure)));
    }

    public static boolean doesNotHaveStructureType(BiomeLoadingEvent context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().noneMatch(structure -> context.getGeneration().getStructures().stream().anyMatch(structureFeatureSupplier -> ((StructureFeature)structureFeatureSupplier.get()).field_236268_b_.equals(structure)));
    }
}

