/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.RegistryObject;

public class GeneralUtils {
    private static final Map<BlockState, Boolean> IS_FULLCUBE_MAP = new HashMap<BlockState, Boolean>();
    private static Set<RegistryKey<World>> BLACKLISTED_WORLDS = null;

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(IWorldReader world, BlockPos pos, BlockState state) {
        if (!IS_FULLCUBE_MAP.containsKey(state)) {
            boolean isFullCube = Block.func_208062_a((VoxelShape)state.func_235754_c_((IBlockReader)world, pos)) || state.func_177230_c() instanceof LeavesBlock;
            IS_FULLCUBE_MAP.put(state, isFullCube);
        }
        return IS_FULLCUBE_MAP.get(state);
    }

    public static BlockState orientateChest(IServerWorld blockView, BlockPos blockPos, BlockState blockState) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        Direction bestDirection = (Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D);
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            mutable.func_189533_g((Vector3i)blockPos).func_189536_c(facing);
            if (!GeneralUtils.isFullCube((IWorldReader)blockView, (BlockPos)mutable, blockView.func_180495_p((BlockPos)mutable))) continue;
            bestDirection = facing;
            mutable.func_189534_c(facing.func_176734_d(), 2);
            if (blockView.func_180495_p((BlockPos)mutable).func_185904_a().func_76220_a()) continue;
            break;
        }
        return (BlockState)blockState.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)bestDirection.func_176734_d());
    }

    public static boolean serializeAndCompareFeature(ConfiguredFeature<?, ?> configuredFeature1, ConfiguredFeature<?, ?> configuredFeature2) {
        Optional configuredFeatureJSON1 = ConfiguredFeature.field_242763_a.encode(configuredFeature1, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        Optional configuredFeatureJSON2 = ConfiguredFeature.field_242763_a.encode(configuredFeature2, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if (!configuredFeatureJSON1.isPresent() || !configuredFeatureJSON2.isPresent()) {
            return false;
        }
        return configuredFeatureJSON1.equals(configuredFeatureJSON2);
    }

    public static boolean isWorldBlacklisted(IServerWorld world) {
        if (BLACKLISTED_WORLDS == null) {
            BLACKLISTED_WORLDS = Arrays.stream(RepurposedStructures.RSMainConfig.blacklistedDimensions.get().split(",")).map(String::trim).map(dimensionName -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dimensionName))).collect(Collectors.toSet());
        }
        return BLACKLISTED_WORLDS.contains(world.func_201672_e().func_234923_W_());
    }

    public static <T extends IFeatureConfig> void registerStructureDebugging(RegistryObject<Structure<T>> structure) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (!event.getWorld().func_201670_d() && event.getHand() == Hand.MAIN_HAND) {
                RepurposedStructures.LOGGER.info("Started search");
                ServerWorld serverWorld = (ServerWorld)event.getWorld();
                ChunkGenerator chunkGenerator = serverWorld.func_72863_F().func_201711_g();
                StructureSeparationSettings structureseparationsettings = chunkGenerator.func_235957_b_().func_236197_a_((Structure)RSStructures.NETHER_STRONGHOLD.get());
                Structure structureToFind = (Structure)structure.get();
                ArrayList<Pair> structureStarts = new ArrayList<Pair>();
                int spacing = structureseparationsettings.func_236668_a_();
                int startX = 0;
                int startZ = 0;
                int maxRadius = 20;
                SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
                block0: for (int currentRadius = 0; currentRadius <= maxRadius; ++currentRadius) {
                    for (int xRadius = -currentRadius; xRadius <= currentRadius; ++xRadius) {
                        boolean onXEdge = xRadius == -currentRadius || xRadius == currentRadius;
                        for (int zRadius = -currentRadius; zRadius <= currentRadius; ++zRadius) {
                            boolean onZEdge;
                            boolean bl = onZEdge = zRadius == -currentRadius || zRadius == currentRadius;
                            if (onXEdge || onZEdge) {
                                int k1 = startX + spacing * xRadius;
                                int l1 = startZ + spacing * zRadius;
                                ChunkPos chunkpos = structureToFind.func_236392_a_(structureseparationsettings, serverWorld.func_72905_C(), sharedseedrandom, k1, l1);
                                IChunk ichunk = serverWorld.func_217348_a(chunkpos.field_77276_a, chunkpos.field_77275_b, ChunkStatus.field_222606_b);
                                StructureStart structurestart = serverWorld.func_241112_a_().func_235013_a_(SectionPos.func_218156_a((ChunkPos)ichunk.func_76632_l(), (int)0), structureToFind, (IStructureReader)ichunk);
                                if (structurestart != null && structurestart.func_75069_d()) {
                                    BlockPos pos = structurestart.func_204294_a();
                                    structureStarts.add(Pair.of((Object)pos, (Object)((int)Math.sqrt(pos.func_177958_n() * pos.func_177958_n() + pos.func_177952_p() * pos.func_177952_p()))));
                                }
                                if (currentRadius != 0) continue;
                                break;
                            }
                            zRadius = currentRadius - 1;
                        }
                        if (currentRadius == 0) continue block0;
                    }
                }
                structureStarts.sort(Comparator.comparingInt(Pair::getSecond));
                structureStarts.forEach(pair -> RepurposedStructures.LOGGER.info("position: {} - distance: {}", pair.getFirst(), pair.getSecond()));
                boolean bl = true;
            }
        });
    }

    public static ItemStack enchantRandomly(Random random, ItemStack itemToEnchant, float chance) {
        List list;
        if (random.nextFloat() < chance && !(list = Registry.field_212628_q.func_201756_e().filter(Enchantment::func_230310_i_).filter(enchantmentToCheck -> enchantmentToCheck.func_92089_a(itemToEnchant)).collect(Collectors.toList())).isEmpty()) {
            Enchantment enchantment = (Enchantment)list.get(random.nextInt(list.size()));
            int enchantmentLevel = random.nextInt(MathHelper.func_76136_a((Random)random, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b()) + 1);
            itemToEnchant.func_77966_a(enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }
}

