/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class BuriableStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    private final ResourceLocation startPool;
    private final int offsetAmount;
    private final boolean onLand;

    public BuriableStructure(ResourceLocation startPool) {
        this(startPool, 14, true);
    }

    public BuriableStructure(ResourceLocation startPool, boolean onLand) {
        this(startPool, 14, onLand);
    }

    public BuriableStructure(ResourceLocation startPool, int offsetAmount) {
        this(startPool, offsetAmount, true);
    }

    public BuriableStructure(ResourceLocation startPool, int offsetAmount, boolean onLand) {
        super(NoFeatureConfig.field_236558_a_);
        this.startPool = startPool;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
        this.offsetAmount = offsetAmount;
        this.onLand = onLand;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            BlockPos blockPos = new BlockPos(chunkX * 16, chunkGenerator.func_230356_f_(), chunkZ * 16);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(BuriableStructure.this.startPool), 1), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockPos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)false);
            ((StructurePiece)this.field_75075_a.get(1)).func_74874_b().func_78888_b(((StructurePiece)this.field_75075_a.get(0)).func_74874_b());
            this.func_202500_a();
            Rotation rotation = ((StructurePiece)this.field_75075_a.get(0)).func_214809_Y_();
            BlockPos maxCorner = new BlockPos(((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_78883_b(), 0, ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_78880_d()).func_190942_a(rotation);
            Heightmap.Type heightMapToUse = BuriableStructure.this.onLand ? Heightmap.Type.WORLD_SURFACE_WG : Heightmap.Type.OCEAN_FLOOR_WG;
            int highestLandPos = chunkGenerator.func_222529_a(blockPos.func_177958_n() + maxCorner.func_177958_n(), blockPos.func_177952_p() + maxCorner.func_177952_p(), heightMapToUse);
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(blockPos.func_177958_n(), blockPos.func_177952_p() + maxCorner.func_177952_p(), heightMapToUse));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(blockPos.func_177958_n() + maxCorner.func_177958_n(), blockPos.func_177952_p(), heightMapToUse));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(blockPos.func_177958_n(), blockPos.func_177952_p(), heightMapToUse));
            this.func_214626_a((Random)this.field_214631_d, highestLandPos - (BuriableStructure.this.offsetAmount + 1), highestLandPos - BuriableStructure.this.offsetAmount);
        }
    }
}

