/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class CityNetherStructure
extends GenericJigsawStructure {
    public CityNetherStructure(ResourceLocation poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, List<MobSpawnInfo.Spawners> monsterSpawns, List<MobSpawnInfo.Spawners> creatureSpawns) {
        this(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, -1, 0, monsterSpawns, creatureSpawns);
    }

    public CityNetherStructure(ResourceLocation poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, List<MobSpawnInfo.Spawners> monsterSpawns, List<MobSpawnInfo.Spawners> creatureSpawns) {
        super(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, allowTerrainHeightRange, terrainHeightRadius, monsterSpawns, creatureSpawns);
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        if (super.isFeatureChunk(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, noFeatureConfig)) {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int curChunkX = chunkX - 1; curChunkX <= chunkX + 1; ++curChunkX) {
                for (int curChunkZ = chunkZ - 1; curChunkZ <= chunkZ + 1; ++curChunkZ) {
                    mutable.func_181079_c(curChunkX << 4, chunkGenerator.func_230356_f_() + 10, curChunkZ << 4);
                    IBlockReader blockView = chunkGenerator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
                    int minValidSpace = 65;
                    int maxHeight = Math.min(chunkGenerator.func_230355_e_(), chunkGenerator.func_230356_f_() + minValidSpace);
                    while (mutable.func_177956_o() < maxHeight) {
                        BlockState state = blockView.func_180495_p((BlockPos)mutable);
                        if (!state.func_196958_f()) {
                            return false;
                        }
                        mutable.func_189536_c(Direction.UP);
                    }
                }
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class MainStart
    extends MarginedStructureStart<NoFeatureConfig> {
        public MainStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            BlockPos blockpos = new BlockPos(chunkX * 16, chunkGenerator.func_230356_f_(), chunkZ * 16);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(CityNetherStructure.this.startPool), CityNetherStructure.this.structureSize), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            this.func_202500_a();
            ((StructurePiece)this.field_75075_a.get(0)).func_181138_a(0, CityNetherStructure.this.centerOffset, 0);
        }
    }
}

