/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.CheckerboardBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class GenericJigsawStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    protected final ResourceLocation startPool;
    protected final int structureSize;
    protected final int centerOffset;
    protected final int biomeRange;
    protected final int structureBlacklistRange;
    protected final Set<RSStructureTagMap.STRUCTURE_TAGS> structureTagsSet;
    protected final List<MobSpawnInfo.Spawners> monsterSpawns;
    protected final List<MobSpawnInfo.Spawners> creatureSpawns;
    protected final int allowTerrainHeightRange;
    protected final int terrainHeightRadius;
    protected final int minHeightLimit;
    protected int fixedYSpawn = 0;
    protected boolean useHeightmap = true;

    public GenericJigsawStructure(ResourceLocation poolRL, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet) {
        this(poolRL, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, -1, 0);
    }

    public GenericJigsawStructure(ResourceLocation poolRL, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius) {
        this(poolRL, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, allowTerrainHeightRange, terrainHeightRadius, new ArrayList<MobSpawnInfo.Spawners>(), new ArrayList<MobSpawnInfo.Spawners>());
    }

    public GenericJigsawStructure(ResourceLocation poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, List<MobSpawnInfo.Spawners> monsterSpawns, List<MobSpawnInfo.Spawners> creatureSpawns) {
        this(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, -1, 0, monsterSpawns, creatureSpawns);
    }

    public GenericJigsawStructure(ResourceLocation poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, List<MobSpawnInfo.Spawners> monsterSpawns, List<MobSpawnInfo.Spawners> creatureSpawns) {
        this(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, allowTerrainHeightRange, terrainHeightRadius, monsterSpawns, creatureSpawns, Integer.MIN_VALUE);
    }

    public GenericJigsawStructure(ResourceLocation poolID, int biomeRange, int structureSize, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, List<MobSpawnInfo.Spawners> monsterSpawns, int fixedHeight) {
        this(poolID, structureSize, 0, biomeRange, structureBlacklistRange, avoidStructuresSet, -1, 0, monsterSpawns, new ArrayList<MobSpawnInfo.Spawners>(), Integer.MIN_VALUE);
        this.fixedYSpawn = fixedHeight;
        this.useHeightmap = false;
    }

    public GenericJigsawStructure(ResourceLocation poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, List<MobSpawnInfo.Spawners> monsterSpawns, List<MobSpawnInfo.Spawners> creatureSpawns, int minHeightLimit) {
        super(NoFeatureConfig.field_236558_a_);
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.centerOffset = centerOffset;
        this.biomeRange = biomeRange;
        this.structureBlacklistRange = structureBlacklistRange;
        this.structureTagsSet = avoidStructuresSet;
        this.monsterSpawns = monsterSpawns;
        this.creatureSpawns = creatureSpawns;
        this.allowTerrainHeightRange = allowTerrainHeightRange;
        this.terrainHeightRadius = terrainHeightRadius;
        this.minHeightLimit = minHeightLimit;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return this.monsterSpawns;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return this.creatureSpawns;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        int curChunkZ;
        int curChunkX;
        if (!(biomeSource instanceof CheckerboardBiomeProvider)) {
            for (curChunkX = chunkX - this.biomeRange; curChunkX <= chunkX + this.biomeRange; ++curChunkX) {
                for (curChunkZ = chunkZ - this.biomeRange; curChunkZ <= chunkZ + this.biomeRange; ++curChunkZ) {
                    if (biomeSource.func_225526_b_(curChunkX << 2, 64, curChunkZ << 2).func_242440_e().func_242493_a((Structure)this)) continue;
                    return false;
                }
            }
        }
        for (curChunkX = chunkX - this.structureBlacklistRange; curChunkX <= chunkX + this.structureBlacklistRange; ++curChunkX) {
            for (curChunkZ = chunkZ - this.structureBlacklistRange; curChunkZ <= chunkZ + this.structureBlacklistRange; ++curChunkZ) {
                if (curChunkX == chunkX && curChunkZ == chunkZ) continue;
                for (RSStructureTagMap.STRUCTURE_TAGS tag : this.structureTagsSet) {
                    for (Structure<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag)) {
                        StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_(structureFeature);
                        if (structureConfig == null || structureConfig.func_236668_a_() <= 8) continue;
                        ChunkPos chunkPos2 = structureFeature.func_236392_a_(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                        if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                        return false;
                    }
                }
            }
        }
        if (this.allowTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX2 = chunkX - this.terrainHeightRadius; curChunkX2 <= chunkX + this.terrainHeightRadius; ++curChunkX2) {
                for (int curChunkZ2 = chunkZ - this.terrainHeightRadius; curChunkZ2 <= chunkZ + this.terrainHeightRadius; ++curChunkZ2) {
                    int height = chunkGenerator.func_222531_c((curChunkX2 << 4) + 7, (curChunkZ2 << 4) + 7, Heightmap.Type.WORLD_SURFACE_WG);
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= this.minHeightLimit) continue;
                    return false;
                }
            }
            return maxTerrainHeight - minTerrainHeight <= this.allowTerrainHeightRange;
        }
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class MainStart
    extends MarginedStructureStart<NoFeatureConfig> {
        public MainStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            BlockPos blockpos = new BlockPos(chunkX * 16, GenericJigsawStructure.this.fixedYSpawn, chunkZ * 16);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(GenericJigsawStructure.this.startPool), GenericJigsawStructure.this.structureSize), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)GenericJigsawStructure.this.useHeightmap, (boolean)GenericJigsawStructure.this.useHeightmap);
            this.func_202500_a();
            ((StructurePiece)this.field_75075_a.get(0)).func_181138_a(0, GenericJigsawStructure.this.centerOffset, 0);
        }
    }
}

