/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.util.Lazy;

public class RSMineshaftStructure
extends AdvancedJigsawStructure {
    protected final Lazy<Float> probability;
    protected final ENVIRONMENT_CHECK environmentCheck;

    public RSMineshaftStructure(ResourceLocation poolID, Lazy<Integer> structureSize, Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, Lazy<Integer> maxY, Lazy<Integer> minY, Lazy<Float> probability, ENVIRONMENT_CHECK environmentCheck) {
        super(poolID, structureSize, requiredPieces, maxY, minY);
        this.probability = probability;
        this.environmentCheck = environmentCheck;
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_((Structure)this);
        if (structureConfig != null) {
            chunkRandom.func_202425_c(seed + (long)structureConfig.func_236673_c_(), x, z);
            double d = (double)((Float)this.probability.get()).floatValue() / 10000.0;
            return chunkRandom.nextDouble() < d;
        }
        return false;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends AdvancedJigsawStructure.MainStart {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @Override
        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig noFeatureConfig) {
            super.generatePieces(dynamicRegistryManager, chunkGenerator, structureManager, chunkX, chunkZ, biome, noFeatureConfig);
        }

        private boolean isEnvironmentInvalidInBounds(ChunkGenerator chunkGenerator, BlockPos.Mutable mutable, MutableBoundingBox boundingBox, ENVIRONMENT_CHECK environmentCheck) {
            for (int x = boundingBox.field_78897_a - 1; x <= boundingBox.field_78893_d + 1; ++x) {
                for (int z = boundingBox.field_78896_c - 1; z <= boundingBox.field_78892_f + 1; ++z) {
                    IBlockReader columnSample = chunkGenerator.func_230348_a_(x, z);
                    for (int y = boundingBox.field_78895_b - 1; y <= boundingBox.field_78894_e + 1; ++y) {
                        if (!(environmentCheck == ENVIRONMENT_CHECK.LIQUID ? !columnSample.func_180495_p((BlockPos)mutable.func_181079_c(x, y, z)).func_204520_s().func_206888_e() : environmentCheck == ENVIRONMENT_CHECK.AIR && columnSample.func_180495_p((BlockPos)mutable.func_181079_c(x, y, z)).func_196958_f())) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static enum ENVIRONMENT_CHECK {
        NONE,
        LIQUID,
        AIR;

    }
}

