/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class VillageNetherStructure
extends GenericJigsawStructure {
    public VillageNetherStructure(ResourceLocation poolRL, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet) {
        super(poolRL, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet);
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        for (int curChunkX = chunkX - 10; curChunkX <= chunkX + 10; ++curChunkX) {
            for (int curChunkZ = chunkZ - 10; curChunkZ <= chunkZ + 10; ++curChunkZ) {
                for (Structure<?> outpost : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.NETHER_OUTPOST)) {
                    StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_(outpost);
                    if (structureConfig == null || structureConfig.func_236668_a_() <= 10) continue;
                    ChunkPos chunkPos2 = outpost.func_236392_a_(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                    return false;
                }
            }
        }
        return super.isFeatureChunk(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, noFeatureConfig);
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public static BlockPos getHighestLand(ChunkGenerator chunkGenerator, MutableBoundingBox bounds) {
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_181079_c(bounds.func_215126_f().func_177958_n(), chunkGenerator.func_230355_e_() - 20, bounds.func_215126_f().func_177952_p());
        IBlockReader blockView = chunkGenerator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
        while (mutable.func_177956_o() > chunkGenerator.func_230356_f_() + 1) {
            BlockState currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
            if (!currentBlockstate.func_235785_r_(blockView, (BlockPos)mutable)) {
                mutable.func_189536_c(Direction.DOWN);
                continue;
            }
            if (blockView.func_180495_p(mutable.func_177982_a(0, 3, 0)).func_185904_a() == Material.field_151579_a && VillageNetherStructure.isValidBlock(currentBlockstate)) break;
            mutable.func_189536_c(Direction.DOWN);
        }
        return mutable;
    }

    private static boolean isValidBlock(BlockState currentBlockstate) {
        return BlockTags.field_241278_aD_.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_205599_H.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_203436_u.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_232873_an_.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_205213_E.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_199898_b.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_200026_c.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_219755_X.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_199897_a.func_230235_a_((Object)currentBlockstate.func_177230_c()) || currentBlockstate.func_185904_a() == Material.field_151595_p || currentBlockstate.func_185904_a() == Material.field_151576_e || currentBlockstate.func_185904_a() == Material.field_151578_c;
    }

    public class Start
    extends GenericJigsawStructure.MainStart {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @Override
        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            super.generatePieces(dynamicRegistryManager, chunkGenerator, structureManager, chunkX, chunkZ, biome, NoFeatureConfig2);
            BlockPos lowestLandPos = VillageNetherStructure.getHighestLand(chunkGenerator, this.field_75074_b);
            if (lowestLandPos.func_177956_o() >= chunkGenerator.func_230355_e_() - 20 || lowestLandPos.func_177956_o() <= chunkGenerator.func_230356_f_() + 1) {
                this.func_214626_a((Random)this.field_214631_d, chunkGenerator.func_230356_f_() - 12, chunkGenerator.func_230356_f_() - 11);
            } else {
                this.func_214626_a((Random)this.field_214631_d, lowestLandPos.func_177956_o() - 13, lowestLandPos.func_177956_o() - 12);
            }
        }
    }
}

