/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.client;

import com.paleimitations.schoolsofmagic.client.items.models.BookModel;
import com.paleimitations.schoolsofmagic.common.data.BindingType;
import com.paleimitations.schoolsofmagic.common.data.TeaUtils;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="schoolsofmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    private static final Logger LOGGER = LogManager.getLogger();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelBakeEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)BookModel.RESOURCE_LOCATION, (IModelLoader)BookModel.Loader.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void stitcherEventPre(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_() == PlayerContainer.field_226615_c_) {
            event.addSprite(new ResourceLocation("schoolsofmagic:item/book/cover"));
            for (DyeColor dyeColor : DyeColor.values()) {
                event.addSprite(new ResourceLocation("schoolsofmagic:item/book/cover_" + dyeColor.func_176762_d()));
            }
            for (BindingType bindingType : BindingType.values()) {
                event.addSprite(new ResourceLocation("schoolsofmagic:item/book/binding_" + bindingType.func_176610_l()));
            }
            for (BookData.DecorationType decorationType : BookData.DecorationType.values()) {
                event.addSprite(new ResourceLocation("schoolsofmagic:item/book/decor_" + decorationType.func_176610_l()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerColors(ColorHandlerEvent.Item event) {
        ItemColors itemcolors = event.getItemColors();
        itemcolors.func_199877_a((itemStack, tint) -> tint > 0 ? -1 : TeaUtils.getColor(itemStack), new IItemProvider[]{(IItemProvider)ItemRegistry.FILLED_WHITE_TEACUP.get(), (IItemProvider)ItemRegistry.FILLED_WHITE_TERRACOTTA_TEACUP.get()});
    }
}

