/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.client.data;

import com.paleimitations.schoolsofmagic.common.data.books.BookPage;
import com.paleimitations.schoolsofmagic.common.data.books.PageElement;
import com.paleimitations.schoolsofmagic.common.data.books.PageElementParagraphs;
import com.paleimitations.schoolsofmagic.common.registries.BookPageRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public enum BookTextManager implements ISelectiveResourceReloadListener
{
    INSTANCE;

    private IResourceManager manager;
    private final Map<ResourceLocation, IResource> cache = new HashMap<ResourceLocation, IResource>();

    @Nullable
    public IResourceType getResourceType() {
        return VanillaResourceType.LANGUAGES;
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test(this.getResourceType())) {
            this.func_195410_a(resourceManager);
        }
    }

    public void func_195410_a(IResourceManager resourceManager) {
        System.out.println("Book Text reloaded");
        this.manager = resourceManager;
        this.cache.clear();
        BookTextManager.loadText();
    }

    public IResource loadTextFile(ResourceLocation fileLoc, ResourceLocation backupLoc) {
        if (this.manager == null) {
            this.manager = Minecraft.func_71410_x().func_195551_G();
        }
        if (this.cache.containsKey(fileLoc)) {
            return this.cache.get(fileLoc);
        }
        IResource resource = null;
        try {
            resource = this.manager.func_199002_a(fileLoc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (resource != null) {
            return resource;
        }
        if (this.cache.containsKey(backupLoc)) {
            return this.cache.get(backupLoc);
        }
        resource = null;
        try {
            resource = this.manager.func_199002_a(backupLoc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resource;
    }

    public static void loadText() {
        for (BookPage page : BookPageRegistry.PAGES) {
            for (PageElement element : page.elements) {
                if (!(element instanceof PageElementParagraphs)) continue;
                ((PageElementParagraphs)element).loadText();
            }
        }
    }

    public static void loadText(BookPage page) {
        for (PageElement element : page.elements) {
            if (!(element instanceof PageElementParagraphs)) continue;
            ((PageElementParagraphs)element).loadText();
        }
    }
}

