/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.client.items.models;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.paleimitations.schoolsofmagic.common.data.BindingType;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

public class BookModel
implements IModelGeometry<BookModel> {
    public static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("schoolsofmagic", "book");
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(RESOURCE_LOCATION, "inventory");
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_DECOR = 0.4675f;
    private static final float SOUTH_Z_DECOR = 0.531875f;
    private static final float NORTH_Z_DECOR2 = 0.466875f;
    private static final float SOUTH_Z_DECOR2 = 0.5325f;
    @Nullable
    private final ResourceLocation coverLocation;
    @Nullable
    private final ResourceLocation bindingLocation;
    @Nullable
    private final ResourceLocation decorLocation;
    @Nullable
    private final ResourceLocation decorLocation2;

    public BookModel() {
        this(null, null, null, null);
    }

    public BookModel(ResourceLocation coverLocation, ResourceLocation bindingLocation, ResourceLocation decorLocation, ResourceLocation decorLocation2) {
        this.coverLocation = coverLocation;
        this.bindingLocation = bindingLocation;
        this.decorLocation = decorLocation;
        this.decorLocation2 = decorLocation2;
        System.out.println("Basic Arcana Model run");
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite decorSprite;
        TextureAtlasSprite particleSprite;
        RenderMaterial particleLocation = owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : null;
        IModelTransform transformsFromModel = owner.getCombinedTransform();
        TextureAtlasSprite coverSprite = ModelLoader.instance().getSpriteMap().func_229152_a_(PlayerContainer.field_226615_c_).func_195424_a(this.coverLocation);
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(transformsFromModel, modelTransform));
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = coverSprite;
        }
        TransformationMatrix transform = modelTransform.func_225615_b_();
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)particleSprite, (ItemOverrideList)new BookOverrideHandler(overrides, bakery, owner, this), (ImmutableMap)transformMap);
        if (coverSprite != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)coverSprite, (TransformationMatrix)transform, (boolean)false));
            System.out.println("Basic Arcana cover used");
        }
        if (this.bindingLocation != null) {
            TextureAtlasSprite bindingSprite = ModelLoader.instance().getSpriteMap().func_229152_a_(AtlasTexture.field_110575_b).func_195424_a(this.bindingLocation);
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.4685f, (TextureAtlasSprite)bindingSprite, (Direction)Direction.NORTH, (int)-1, (int)2)});
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.5315f, (TextureAtlasSprite)bindingSprite, (Direction)Direction.SOUTH, (int)-1, (int)2)});
            System.out.println("Basic Arcana binding used");
        }
        if (this.decorLocation != null) {
            decorSprite = ModelLoader.instance().getSpriteMap().func_229152_a_(AtlasTexture.field_110575_b).func_195424_a(this.decorLocation);
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.4675f, (TextureAtlasSprite)decorSprite, (Direction)Direction.NORTH, (int)-1, (int)2)});
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.531875f, (TextureAtlasSprite)decorSprite, (Direction)Direction.SOUTH, (int)-1, (int)2)});
            System.out.println("Basic Arcana decor used");
        }
        if (this.decorLocation2 != null) {
            decorSprite = ModelLoader.instance().getSpriteMap().func_229152_a_(AtlasTexture.field_110575_b).func_195424_a(this.decorLocation2);
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.466875f, (TextureAtlasSprite)decorSprite, (Direction)Direction.NORTH, (int)-1, (int)2)});
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.5325f, (TextureAtlasSprite)decorSprite, (Direction)Direction.SOUTH, (int)-1, (int)2)});
            System.out.println("Basic Arcana decor used");
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        return texs;
    }

    private static final class BookOverrideHandler
    extends ItemOverrideList {
        private final Map<String, IBakedModel> cache = Maps.newHashMap();
        private final ItemOverrideList nested;
        private final ModelBakery bakery;
        private final IModelConfiguration owner;
        private final BookModel parent;

        private BookOverrideHandler(ItemOverrideList nested, ModelBakery bakery, IModelConfiguration owner, BookModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            IBakedModel overriden = this.nested.func_239290_a_(originalModel, stack, world, entity);
            if (overriden != originalModel) {
                return overriden;
            }
            CompoundNBT nbt = stack.func_196082_o();
            DyeColor color = nbt.func_74764_b("dye") ? DyeColor.func_196056_a((int)nbt.func_74762_e("dye")) : null;
            BindingType binding = nbt.func_74764_b("binding") ? BindingType.fromName(nbt.func_74779_i("binding")) : null;
            BookData.DecorationType decoration = nbt.func_74764_b("decor") ? BookData.DecorationType.fromName(nbt.func_74779_i("decor")) : null;
            BookData.DecorationType decoration2 = nbt.func_74764_b("decor_sec") ? BookData.DecorationType.fromName(nbt.func_74779_i("decor_sec")) : null;
            String name = "book" + (color != null ? "_" + color.func_176762_d() : "") + (binding != null ? "_" + binding.func_176610_l() : "") + (decoration != null ? "_" + decoration.func_176610_l() : "") + (decoration2 != null ? "_" + decoration2.func_176610_l() : "");
            if (!this.cache.containsKey(name)) {
                ResourceLocation coverLoc = new ResourceLocation("schoolsofmagic:item/book/cover" + (color != null ? "_" + color.func_176762_d() : ""));
                ResourceLocation bindingLoc = binding != null ? new ResourceLocation("schoolsofmagic:item/book/binding_" + binding.func_176610_l()) : null;
                ResourceLocation decorLoc = decoration != null ? new ResourceLocation("schoolsofmagic:item/book/decor_" + decoration.func_176610_l()) : null;
                ResourceLocation decorLoc2 = decoration2 != null ? new ResourceLocation("schoolsofmagic:item/book/decor_" + decoration2.func_176610_l()) : null;
                BookModel unbaked = new BookModel(coverLoc, bindingLoc, decorLoc, decorLoc2);
                IBakedModel bakedModel = unbaked.bake(this.owner, this.bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, this, new ResourceLocation("schoolsofmagic", "book"));
                this.cache.put(name, bakedModel);
                System.out.println("Basic Arcana cached: " + name);
                return bakedModel;
            }
            return this.cache.get(name);
        }
    }

    public static enum Loader implements IModelLoader<BookModel>
    {
        INSTANCE;


        public IResourceType getResourceType() {
            return VanillaResourceType.MODELS;
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }

        public BookModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new BookModel();
        }
    }
}

