/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.paleimitations.schoolsofmagic.common.data.BindingType;
import com.paleimitations.schoolsofmagic.common.data.BookUtils;
import com.paleimitations.schoolsofmagic.common.data.books.PageElement;
import com.paleimitations.schoolsofmagic.common.data.books.PageElementPageButton;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookDataProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GrimoireScreen
extends Screen {
    private ItemStack stack;
    private final int imageWidth = 256;
    private final int imageHeight = 256;
    private static ResourceLocation[] COVERS = new ResourceLocation[DyeColor.values().length + 1];
    private static ResourceLocation[] BINDINGS = new ResourceLocation[BindingType.values().length];
    private static final ResourceLocation PAPER = new ResourceLocation("schoolsofmagic", "textures/gui/books/grimoire_paper.png");
    private static final ResourceLocation MENU_OPTIONS = new ResourceLocation("schoolsofmagic", "textures/gui/books/menu_options.png");
    private int leftPos;
    private int topPos;
    private TurnPageButton nextPage;
    private TurnPageButton backPage;
    private TurnChapterButton nextChapter;
    private TurnChapterButton backChapter;
    private IndexReturnButton indexReturn;
    private CloseButton closeBook;
    private PlayerEntity player;
    private Hand hand;

    public GrimoireScreen(ItemStack stack, Hand hand) {
        super(NarratorChatListener.field_216868_a);
        this.stack = stack;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.hand = hand;
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        switch (p_231046_1_) {
            case 266: {
                this.nextPage.func_230930_b_();
                return true;
            }
            case 267: {
                this.backPage.func_230930_b_();
                return true;
            }
        }
        return false;
    }

    protected void chapterBack() {
        if (this.stack != null) {
            Tuple<Integer, Integer> chapters;
            ActionResult<ItemStack> result;
            CompoundNBT nbt = this.stack.func_77978_p();
            int page = nbt.func_74762_e("page");
            BookData data = BookDataProvider.getBook((World)this.field_230706_i_.field_71441_e, this.stack);
            if (data != null && (result = BookUtils.turnPage(data, this.stack, (Integer)(chapters = data.getSurroundingChapters(page)).func_76341_a(), this.hand)).func_188397_a() == ActionResultType.SUCCESS) {
                this.stack = (ItemStack)result.func_188398_b();
                this.player.func_184611_a(this.hand, this.stack);
                this.updateButtonVisibility();
            }
        }
    }

    protected void chapterForward() {
        if (this.stack != null) {
            Tuple<Integer, Integer> chapters;
            ActionResult<ItemStack> result;
            CompoundNBT nbt = this.stack.func_77978_p();
            int page = nbt.func_74762_e("page");
            BookData data = BookDataProvider.getBook((World)this.field_230706_i_.field_71441_e, this.stack);
            if (data != null && (result = BookUtils.turnPage(data, this.stack, (Integer)(chapters = data.getSurroundingChapters(page)).func_76340_b(), this.hand)).func_188397_a() == ActionResultType.SUCCESS) {
                this.stack = (ItemStack)result.func_188398_b();
                this.player.func_184611_a(this.hand, this.stack);
                this.updateButtonVisibility();
            }
        }
    }

    protected void pageBack() {
        BookData data;
        ActionResult<ItemStack> result;
        if (this.stack != null && (result = BookUtils.turnPage(data = BookDataProvider.getBook((World)this.field_230706_i_.field_71441_e, this.stack), this.stack, false, this.hand)).func_188397_a() == ActionResultType.SUCCESS) {
            this.stack = (ItemStack)result.func_188398_b();
            this.player.func_184611_a(this.hand, this.stack);
            this.updateButtonVisibility();
        }
    }

    protected void pageForward() {
        BookData data;
        ActionResult<ItemStack> result;
        if (this.stack != null && (result = BookUtils.turnPage(data = BookDataProvider.getBook((World)this.field_230706_i_.field_71441_e, this.stack), this.stack, true, this.hand)).func_188397_a() == ActionResultType.SUCCESS) {
            this.stack = (ItemStack)result.func_188398_b();
            this.player.func_184611_a(this.hand, this.stack);
            this.updateButtonVisibility();
        }
    }

    protected void indexReturn() {
        BookData data;
        ActionResult<ItemStack> result;
        if (this.stack != null && (result = BookUtils.turnPage(data = BookDataProvider.getBook((World)this.field_230706_i_.field_71441_e, this.stack), this.stack, 0, this.hand)).func_188397_a() == ActionResultType.SUCCESS) {
            this.stack = (ItemStack)result.func_188398_b();
            this.player.func_184611_a(this.hand, this.stack);
            this.updateButtonVisibility();
        }
    }

    private void updateButtonVisibility() {
        CompoundNBT nbt = this.stack.func_196082_o();
        if (this.stack != null) {
            int page = nbt.func_74762_e("page");
            int subpage = nbt.func_74762_e("subpage");
            BookData data = BookDataProvider.getBook((World)this.field_230706_i_.field_71441_e, this.stack);
            if (data != null && data.getBookPage(page) != null) {
                boolean flag = false;
                for (int i = subpage + 1; i < data.getBookPage(page).getSubPages(); ++i) {
                    if (data.getBookPage(page).isSubPageBlank(i)) continue;
                    flag = true;
                }
                this.nextPage.field_230694_p_ = page + 1 < data.getNumPages() || flag;
                this.backPage.field_230694_p_ = page > 0 || subpage > 0;
                Tuple<Integer, Integer> chaps = data.getSurroundingChapters(page);
                this.nextChapter.field_230694_p_ = (Integer)chaps.func_76340_b() != page;
                this.backChapter.field_230694_p_ = (Integer)chaps.func_76341_a() != page;
            } else {
                this.nextPage.field_230694_p_ = false;
                this.backPage.field_230694_p_ = false;
            }
            this.indexReturn.field_230694_p_ = page != 0 || subpage != 0;
        } else {
            this.nextPage.field_230694_p_ = false;
            this.backPage.field_230694_p_ = false;
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        ((Object)((Object)this)).getClass();
        this.leftPos = (this.field_230708_k_ - 256) / 2;
        ((Object)((Object)this)).getClass();
        this.topPos = (this.field_230709_l_ - 256) / 2;
        this.nextPage = (TurnPageButton)this.func_230480_a_((Widget)new TurnPageButton(this.leftPos + 167, this.topPos + 16, true, pressable -> this.pageForward(), true));
        this.backPage = (TurnPageButton)this.func_230480_a_((Widget)new TurnPageButton(this.leftPos + 70, this.topPos + 16, false, pressable -> this.pageBack(), true));
        this.indexReturn = (IndexReturnButton)this.func_230480_a_((Widget)new IndexReturnButton(this.leftPos + 112, this.topPos + 16, pressable -> this.indexReturn(), true));
        this.closeBook = (CloseButton)this.func_230480_a_((Widget)new CloseButton(this.leftPos + 130, this.topPos + 16, pressable -> this.field_230706_i_.func_147108_a(null), true));
        this.nextChapter = (TurnChapterButton)this.func_230480_a_((Widget)new TurnChapterButton(this.leftPos + 149, this.topPos + 16, true, pressable -> this.chapterForward(), true));
        this.backChapter = (TurnChapterButton)this.func_230480_a_((Widget)new TurnChapterButton(this.leftPos + 93, this.topPos + 16, false, pressable -> this.chapterBack(), true));
        this.updateButtonVisibility();
    }

    public void func_230446_a_(MatrixStack matrix) {
        super.func_230446_a_(matrix);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float p_230430_4_) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(MENU_OPTIONS);
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.func_238474_b_(matrix, this.leftPos, this.topPos, 0, 0, 256, 256);
        super.func_230430_a_(matrix, mouseX, mouseY, p_230430_4_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CompoundNBT nbt = this.stack.func_196082_o();
        int color = 0;
        if (nbt.func_74764_b("dye")) {
            color = nbt.func_74762_e("dye") + 1;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(COVERS[color]);
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.func_238474_b_(matrix, this.leftPos, this.topPos, 0, 0, 256, 256);
        if (nbt.func_74764_b("binding")) {
            this.field_230706_i_.func_110434_K().func_110577_a(BINDINGS[BindingType.fromName(nbt.func_74779_i("binding")).ordinal()]);
            ((Object)((Object)this)).getClass();
            ((Object)((Object)this)).getClass();
            this.func_238474_b_(matrix, this.leftPos, this.topPos, 0, 0, 256, 256);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(PAPER);
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.func_238474_b_(matrix, this.leftPos, this.topPos, 0, 0, 256, 256);
        BookData data = BookDataProvider.getBook((World)this.field_230706_i_.field_71441_e, this.stack);
        int page = nbt.func_74762_e("page");
        int subpage = nbt.func_74762_e("subpage");
        if (data != null && !data.getBookPages().isEmpty() && data.getBookPage(page) != null) {
            data.getBookPage(page).drawPage(matrix, mouseX - this.leftPos, mouseY - this.topPos, this.leftPos, this.topPos, 0.0f, true, subpage, 0xF000F0);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        BookData data = BookDataProvider.getBook((World)this.field_230706_i_.field_71441_e, this.stack);
        CompoundNBT nbt = this.stack.func_196082_o();
        int page = nbt.func_74762_e("page");
        int subpage = nbt.func_74762_e("subpage");
        if (data != null && data.getBookPage(page) != null) {
            for (PageElement element : data.getBookPage((int)page).elements) {
                if (!(element instanceof PageElementPageButton) || !((PageElementPageButton)element).click((float)mouseX - (float)this.leftPos, (float)mouseY - (float)this.topPos, subpage, this.stack, null, this.player, this.hand)) continue;
                this.stack = this.player.func_184586_b(this.hand);
                this.updateButtonVisibility();
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231177_au__() {
        return false;
    }

    static {
        GrimoireScreen.COVERS[0] = new ResourceLocation("schoolsofmagic", "textures/gui/books/cover.png");
        for (DyeColor dyeColor : DyeColor.values()) {
            GrimoireScreen.COVERS[dyeColor.func_196059_a() + 1] = new ResourceLocation("schoolsofmagic", "textures/gui/books/cover_" + dyeColor.func_176762_d() + ".png");
        }
        for (BindingType bindingType : BindingType.values()) {
            GrimoireScreen.BINDINGS[bindingType.ordinal()] = new ResourceLocation("schoolsofmagic", "textures/gui/books/grimoire_" + bindingType.func_176610_l() + "_bindings.png");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CloseButton
    extends Button {
        private final boolean playTurnSound;

        public CloseButton(int x, int y, Button.IPressable action, boolean playTurnSound) {
            super(x, y, 14, 14, StringTextComponent.field_240750_d_, action);
            this.playTurnSound = playTurnSound;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float f) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(MENU_OPTIONS);
            int i = 130;
            int j = 41;
            if (!this.func_230449_g_()) {
                j += 14;
            }
            this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, i, j, 14, 14);
        }

        public void func_230988_a_(SoundHandler handler) {
            if (this.playTurnSound) {
                handler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)0.1f));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class IndexReturnButton
    extends Button {
        private final boolean playTurnSound;

        public IndexReturnButton(int x, int y, Button.IPressable action, boolean playTurnSound) {
            super(x, y, 14, 14, StringTextComponent.field_240750_d_, action);
            this.playTurnSound = playTurnSound;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float f) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(MENU_OPTIONS);
            int i = 112;
            int j = 41;
            if (!this.func_230449_g_()) {
                j += 14;
            }
            this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, i, j, 14, 14);
        }

        public void func_230988_a_(SoundHandler handler) {
            if (this.playTurnSound) {
                handler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class TurnPageButton
    extends Button {
        private final boolean isForward;
        private final boolean playTurnSound;

        public TurnPageButton(int x, int y, boolean isForward, Button.IPressable action, boolean playTurnSound) {
            super(x, y, 19, 14, StringTextComponent.field_240750_d_, action);
            this.isForward = isForward;
            this.playTurnSound = playTurnSound;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float f) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(MENU_OPTIONS);
            int i = 70;
            int j = 41;
            if (!this.func_230449_g_()) {
                j += 14;
            }
            if (this.isForward) {
                i += 97;
            }
            this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, i, j, 19, 14);
        }

        public void func_230988_a_(SoundHandler handler) {
            if (this.playTurnSound) {
                handler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class TurnChapterButton
    extends Button {
        private final boolean isForward;
        private final boolean playTurnSound;

        public TurnChapterButton(int x, int y, boolean isForward, Button.IPressable action, boolean playTurnSound) {
            super(x, y, 14, 14, StringTextComponent.field_240750_d_, action);
            this.isForward = isForward;
            this.playTurnSound = playTurnSound;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float f) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(MENU_OPTIONS);
            int i = 93;
            int j = 41;
            if (!this.func_230449_g_()) {
                j += 14;
            }
            if (this.isForward) {
                i += 56;
            }
            this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, i, j, 14, 14);
        }

        public void func_230988_a_(SoundHandler handler) {
            if (this.playTurnSound) {
                handler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
            }
        }
    }
}

