/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.paleimitations.schoolsofmagic.common.data.books.BookPage;
import com.paleimitations.schoolsofmagic.common.network.LetterPacket;
import com.paleimitations.schoolsofmagic.common.network.PacketHandler;
import com.paleimitations.schoolsofmagic.common.registries.BookPageRegistry;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LetterScreen
extends Screen {
    private ItemStack stack;
    private final int imageHeight = 166;
    private final int imageWidth = 156;
    public static final ResourceLocation LETTER = new ResourceLocation("schoolsofmagic", "textures/gui/letter_ccw.png");
    public static final ResourceLocation CLOSED_ENVELOPE = new ResourceLocation("schoolsofmagic", "textures/gui/envelope_closed.png");
    public static final ResourceLocation OPEN_ENVELOPE = new ResourceLocation("schoolsofmagic", "textures/gui/envelope_open.png");
    private int leftPos;
    private int topPos;
    private PlayerEntity player;
    private final BookPage letter;
    private Button sealButton;
    private Button questButton;
    private Button envelopeButton;
    private Hand hand;
    private int yOffset = 0;
    private int phase;
    private int tick;

    public LetterScreen(ItemStack stack, Hand hand) {
        super(NarratorChatListener.field_216868_a);
        this.stack = stack;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.letter = BookPageRegistry.getBookPage("ccw_letter_1");
        this.hand = hand;
    }

    private void updateButtonVisibility() {
        this.sealButton.field_230694_p_ = this.stack != null && this.stack.func_77973_b() == ItemRegistry.LETTER_CCW.get() && this.phase == 1 && (!this.stack.func_77942_o() || !this.stack.func_77978_p().func_74767_n("opened"));
        this.questButton.field_230694_p_ = this.stack != null && this.stack.func_77973_b() == ItemRegistry.LETTER_CCW.get() && this.stack.func_196082_o().func_74767_n("opened") && this.stack.func_196082_o().func_74767_n("quest") && this.tick > 40;
        this.envelopeButton.field_230694_p_ = this.stack != null && this.stack.func_77973_b() == ItemRegistry.LETTER_CCW.get() && this.stack.func_196082_o().func_74767_n("opened") && this.tick > 40;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.leftPos = (this.field_230708_k_ - this.imageWidth) / 2;
        this.topPos = (this.field_230709_l_ - this.imageHeight) / 2;
        this.sealButton = (Button)this.func_230480_a_((Widget)new Button((this.field_230708_k_ - 156) / 2 + 64, (this.field_230709_l_ - 166) / 2 + 87, 24, 24, StringTextComponent.field_240750_d_, pressable -> this.openLetter()){

            public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
                if (this.field_230694_p_ && this.func_230449_g_()) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    LetterScreen.this.field_230706_i_.func_110434_K().func_110577_a(CLOSED_ENVELOPE);
                    this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, 173, 87, 24, 24);
                }
            }
        });
        this.questButton = (Button)this.func_230480_a_((Widget)new Button((this.field_230708_k_ - 156) / 2 + 152, (this.field_230709_l_ - 166) / 2 + 32, 30, 62, StringTextComponent.field_240750_d_, pressable -> this.getQuestNote()){

            public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
                if (this.field_230694_p_ && this.func_230449_g_()) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    LetterScreen.this.field_230706_i_.func_110434_K().func_110577_a(LETTER);
                    this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, 209, 0, 30, 62);
                }
            }
        });
        this.envelopeButton = (Button)this.func_230480_a_((Widget)new Button((this.field_230708_k_ - 156) / 2 - 33, (this.field_230709_l_ - 166) / 2 + 28, 37, 122, StringTextComponent.field_240750_d_, pressable -> this.closeLetter()){

            public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
                if (this.field_230694_p_ && this.func_230449_g_()) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    LetterScreen.this.field_230706_i_.func_110434_K().func_110577_a(LETTER);
                    this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, 216, 63, 37, 122);
                }
            }
        });
        this.updateButtonVisibility();
    }

    private void closeLetter() {
        PacketHandler.sendToServer(new LetterPacket(this.player.func_145782_y(), this.hand, 1));
        this.phase = 0;
    }

    private void getQuestNote() {
        PacketHandler.sendToServer(new LetterPacket(this.player.func_145782_y(), this.hand, 2));
    }

    private void openLetter() {
        this.phase = 2;
        this.tick = 0;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTick) {
        this.stack = this.player.func_184586_b(this.hand);
        this.updateButtonVisibility();
        int offsetWidth = (this.field_230708_k_ - 156) / 2;
        int offsetHeight = (this.field_230709_l_ - 166) / 2;
        ++this.tick;
        if (this.stack.func_196082_o().func_74767_n("opened")) {
            if (this.tick > 40) {
                int xOffset;
                int n = xOffset = this.tick < 60 ? (int)(-30.0 * (-Math.cos(((double)this.tick - 40.0 + (double)partialTick) * Math.PI / 20.0) - 1.0)) : 0;
                if (this.stack.func_196082_o().func_74767_n("quest")) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_230706_i_.func_110434_K().func_110577_a(LETTER);
                    this.func_238474_b_(matrix, offsetWidth - xOffset + 152, offsetHeight + 32, 179, 0, 30, 62);
                }
                int xOffset2 = this.tick < 60 ? (int)(37.0 * (-Math.cos(((double)this.tick - 40.0 + (double)partialTick) * Math.PI / 20.0) - 1.0)) : 0;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_230706_i_.func_110434_K().func_110577_a(LETTER);
                this.func_238474_b_(matrix, offsetWidth - xOffset2 - 33, offsetHeight + 28, 179, 63, 37, 122);
            }
            this.yOffset = this.tick < 20 ? (int)((double)this.field_230709_l_ * (-Math.cos(((double)this.tick + (double)partialTick) * Math.PI / 20.0) - 1.0)) : 0;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(LETTER);
            this.func_238474_b_(matrix, offsetWidth, offsetHeight - this.yOffset, 0, 0, 156, 166);
            if (this.letter != null) {
                this.letter.drawPage(matrix, mouseX - offsetWidth, mouseY - offsetHeight - this.yOffset, offsetWidth, offsetHeight - this.yOffset, 20.0f, true, 0, 0xF000F0);
            }
        } else {
            if (this.phase == 0) {
                if (this.tick < 40) {
                    this.yOffset = (int)((double)this.field_230709_l_ * (-Math.cos(((double)this.tick + (double)partialTick) * Math.PI / 40.0) - 1.0));
                } else {
                    this.phase = 1;
                    this.yOffset = 0;
                }
            }
            if (this.phase == 2) {
                if (this.tick > 20 && this.tick < 60) {
                    this.yOffset = (int)((double)this.field_230709_l_ * (Math.cos(((double)this.tick - 20.0 + (double)partialTick) * Math.PI / 40.0) - 1.0));
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_230706_i_.func_110434_K().func_110577_a(OPEN_ENVELOPE);
                this.func_238474_b_(matrix, offsetWidth, offsetHeight - this.yOffset, 0, 0, 156, 166);
                if (this.tick == 60) {
                    PacketHandler.sendToServer(new LetterPacket(this.player.func_145782_y(), this.hand, 0));
                    this.tick = 0;
                }
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_230706_i_.func_110434_K().func_110577_a(CLOSED_ENVELOPE);
                this.func_238474_b_(matrix, offsetWidth, offsetHeight - this.yOffset, 0, 0, 156, 166);
            }
        }
        super.func_230430_a_(matrix, mouseX, mouseY, partialTick);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

