/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data.IQuestData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data.QuestDataProvider;
import com.paleimitations.schoolsofmagic.common.network.PacketHandler;
import com.paleimitations.schoolsofmagic.common.network.QuestNotePacket;
import com.paleimitations.schoolsofmagic.common.quests.Quest;
import com.paleimitations.schoolsofmagic.common.quests.Task;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class QuestPageScreen
extends Screen {
    private final int imageHeight = 166;
    private final int imageWidth = 156;
    private int leftPos;
    private int topPos;
    public static final ResourceLocation QUEST = new ResourceLocation("schoolsofmagic", "textures/gui/quest_paper.png");
    private PlayerEntity player;
    private ItemStack stack;
    private Hand hand;
    private Quest questDisplay;
    private Button startQuestButton;
    private Button clearQuestButton;
    private Button claimQuestButton;
    private Button[] taskButtons = new Button[14];

    public QuestPageScreen(ItemStack stack, Quest q, Hand hand) {
        super(NarratorChatListener.field_216868_a);
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.stack = stack;
        this.hand = hand;
        this.questDisplay = q;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.leftPos = (this.field_230708_k_ - this.imageWidth) / 2;
        this.topPos = (this.field_230709_l_ - this.imageHeight) / 2;
        this.startQuestButton = (Button)this.func_230480_a_((Widget)new Button(this.leftPos + 43, this.topPos + 135, 83, 18, StringTextComponent.field_240750_d_, pressable -> this.startQuest()){

            public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
                if (this.field_230694_p_) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    QuestPageScreen.this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
                    this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, this.func_230449_g_() ? 83 : 0, 184, 83, 18);
                    String line = I18n.func_135052_a((String)"gui.start_quest.name", (Object[])new Object[0]);
                    int textWidth = QuestPageScreen.this.field_230712_o_.func_78256_a(line);
                    QuestPageScreen.this.field_230712_o_.getClass();
                    int textHeight = 9;
                    float scalerWidth = 77.0f / Float.valueOf(textWidth).floatValue();
                    float scalerHeight = 12.0f / Float.valueOf(textHeight).floatValue();
                    float scaler = Math.min(scalerWidth, scalerHeight);
                    int drawX = Math.round((float)(this.field_230690_l_ + 42) - (float)textWidth * scaler / 2.0f);
                    int drawY = Math.round((float)(this.field_230691_m_ + 10) - (float)textHeight * scaler / 2.0f);
                    matrix.func_227860_a_();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    matrix.func_227862_a_(scaler, scaler, scaler);
                    QuestPageScreen.this.field_230712_o_.func_238421_b_(matrix, line, (float)Math.round((float)drawX / scaler), (float)Math.round((float)drawY / scaler), 0);
                    matrix.func_227865_b_();
                }
            }
        });
        this.clearQuestButton = (Button)this.func_230480_a_((Widget)new Button(this.leftPos + 43, this.topPos + 135, 83, 18, StringTextComponent.field_240750_d_, pressable -> this.clearQuest()){

            public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
                if (this.field_230694_p_) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    QuestPageScreen.this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
                    this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, this.func_230449_g_() ? 83 : 0, 184, 83, 18);
                    String line = I18n.func_135052_a((String)"gui.clear_quest.name", (Object[])new Object[0]);
                    int textWidth = QuestPageScreen.this.field_230712_o_.func_78256_a(line);
                    QuestPageScreen.this.field_230712_o_.getClass();
                    int textHeight = 9;
                    float scalerWidth = 77.0f / Float.valueOf(textWidth).floatValue();
                    float scalerHeight = 12.0f / Float.valueOf(textHeight).floatValue();
                    float scaler = Math.min(scalerWidth, scalerHeight);
                    int drawX = Math.round((float)(this.field_230690_l_ + 42) - (float)textWidth * scaler / 2.0f);
                    int drawY = Math.round((float)(this.field_230691_m_ + 10) - (float)textHeight * scaler / 2.0f);
                    matrix.func_227860_a_();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    matrix.func_227862_a_(scaler, scaler, scaler);
                    QuestPageScreen.this.field_230712_o_.func_238421_b_(matrix, line, (float)Math.round((float)drawX / scaler), (float)Math.round((float)drawY / scaler), 0);
                    matrix.func_227865_b_();
                }
            }
        });
        this.claimQuestButton = (Button)this.func_230480_a_((Widget)new Button(this.leftPos + 43, this.topPos + 135, 83, 18, StringTextComponent.field_240750_d_, pressable -> this.claimQuest()){

            public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
                if (this.field_230694_p_) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    QuestPageScreen.this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
                    this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, this.func_230449_g_() ? 83 : 0, 184, 83, 18);
                    String line = I18n.func_135052_a((String)"gui.claim_quest.name", (Object[])new Object[0]);
                    int textWidth = QuestPageScreen.this.field_230712_o_.func_78256_a(line);
                    QuestPageScreen.this.field_230712_o_.getClass();
                    int textHeight = 9;
                    float scalerWidth = 77.0f / Float.valueOf(textWidth).floatValue();
                    float scalerHeight = 12.0f / Float.valueOf(textHeight).floatValue();
                    float scaler = Math.min(scalerWidth, scalerHeight);
                    int drawX = Math.round((float)(this.field_230690_l_ + 42) - (float)textWidth * scaler / 2.0f);
                    int drawY = Math.round((float)(this.field_230691_m_ + 10) - (float)textHeight * scaler / 2.0f);
                    matrix.func_227860_a_();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    matrix.func_227862_a_(scaler, scaler, scaler);
                    QuestPageScreen.this.field_230712_o_.func_238421_b_(matrix, line, (float)Math.round((float)drawX / scaler), (float)Math.round((float)drawY / scaler), 0);
                    matrix.func_227865_b_();
                }
            }
        });
        for (int i = 0; i < 14; ++i) {
            int j = i;
            this.taskButtons[i] = (Button)this.func_230480_a_((Widget)new Button(this.leftPos + (i / 7 == 0 ? -25 : 152), this.topPos + 5 + 22 * (i % 7), 29, 22, StringTextComponent.field_240750_d_, pressable -> this.taskClick(j)){

                public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
                }
            });
        }
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        IQuestData data = QuestDataProvider.getData(this.player);
        boolean flag = this.questDisplay.getQuestGiver() != null && data.hasQuest(this.questDisplay.getQuestGiver());
        this.clearQuestButton.field_230694_p_ = this.questDisplay != null && flag && this.questDisplay.failed;
        this.claimQuestButton.field_230694_p_ = this.questDisplay != null && flag && this.questDisplay.canClaim();
        this.startQuestButton.field_230694_p_ = this.questDisplay != null && !flag;
        for (int i = 0; i < 14; ++i) {
            this.taskButtons[i].field_230694_p_ = this.questDisplay != null && this.questDisplay.tasks != null && flag && i < this.questDisplay.tasks.size() && this.questDisplay.tasks.get(i) != null && this.questDisplay.tasks.get(i).canStart(this.questDisplay);
        }
    }

    private void clearQuest() {
        System.out.println("Sending Quest Note Clear");
        PacketHandler.INSTANCE.sendToServer((Object)new QuestNotePacket(this.player.func_145782_y(), this.hand, 0));
        this.questDisplay.dead = true;
        this.field_230706_i_.func_147108_a(null);
    }

    private void claimQuest() {
        System.out.println("Sending Quest Note Claim");
        PacketHandler.INSTANCE.sendToServer((Object)new QuestNotePacket(this.player.func_145782_y(), this.hand, 1));
        this.field_230706_i_.func_147108_a(null);
    }

    private void startQuest() {
        System.out.println("Sending Quest Note Start");
        PacketHandler.INSTANCE.sendToServer((Object)new QuestNotePacket(this.player.func_145782_y(), this.hand, 2));
        CompoundNBT nbt = this.stack.func_196082_o();
        if (nbt.func_74764_b("quest_giver")) {
            IQuestData data = QuestDataProvider.getData(this.player);
            this.questDisplay.setQuestGiver(nbt.func_186857_a("quest_giver"));
            data.addQuest(this.questDisplay);
        }
        this.updateButtonVisibility();
    }

    private void taskClick(int id) {
        System.out.println("Sending Quest Note Task Start");
        PacketHandler.INSTANCE.sendToServer((Object)new QuestNotePacket(this.player.func_145782_y(), this.hand, 3 + id));
        this.questDisplay.tasks.get(id).setStarted(true);
        this.updateButtonVisibility();
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTick) {
        if (this.questDisplay != null && this.stack != null) {
            int offsetWidth = (this.field_230708_k_ - 156) / 2;
            int offsetHeight = (this.field_230709_l_ - 166) / 2;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
            this.func_238474_b_(matrix, offsetWidth, offsetHeight, 0, 0, 156, 166);
            if (this.questDisplay.failed) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
                this.func_238474_b_(matrix, offsetWidth + 13, offsetHeight + 9, 180, 0, 22, 22);
            } else if (this.questDisplay.completed) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
                this.func_238474_b_(matrix, offsetWidth + 13, offsetHeight + 9, 158, 0, 22, 22);
            }
            String line = I18n.func_135052_a((String)("quest." + this.questDisplay.getResourceLocation().toString() + ".name"), (Object[])new Object[0]);
            int textWidth = this.field_230712_o_.func_78256_a(line);
            this.field_230712_o_.getClass();
            int textHeight = 9;
            float scalerWidth = 126.0f / Float.valueOf(textWidth).floatValue();
            float scalerHeight = 17.0f / Float.valueOf(textHeight).floatValue();
            float scaler = Math.min(scalerWidth, scalerHeight);
            int drawX = Math.round((float)(78 + offsetWidth) - (float)textWidth * scaler / 2.0f);
            int drawY = Math.round((float)(45 + offsetHeight) - (float)textHeight * scaler / 2.0f);
            matrix.func_227860_a_();
            matrix.func_227862_a_(scaler, scaler, scaler);
            this.field_230712_o_.func_238421_b_(matrix, line, (float)Math.round((float)drawX / scaler), (float)Math.round((float)drawY / scaler), 0);
            matrix.func_227865_b_();
            this.field_230712_o_.func_238418_a_(ITextProperties.func_240652_a_((String)I18n.func_135052_a((String)("quest." + this.questDisplay.getResourceLocation().toString() + ".desc"), (Object[])new Object[0])), 15 + offsetWidth, 56 + offsetHeight, 126, 0);
            if (!this.questDisplay.rewards.isEmpty()) {
                ItemStack reward = this.questDisplay.rewards.get(this.player.field_70173_aa / 40 % this.questDisplay.rewards.size());
                this.field_230706_i_.func_175599_af().func_175042_a(reward, 16 + offsetWidth, 136 + offsetHeight);
            }
            if (this.questDisplay.icon != null) {
                this.field_230706_i_.func_175599_af().func_175042_a(this.questDisplay.icon, 72 + offsetWidth, 12 + offsetHeight);
            }
            if (this.questDisplay.tasks.size() > 1 && !this.startQuestButton.field_230694_p_) {
                for (int i = 0; i < this.questDisplay.tasks.size(); ++i) {
                    this.drawTabs(matrix, i, this.questDisplay, this.questDisplay.tasks.get(i));
                }
            }
            super.func_230430_a_(matrix, mouseX, mouseY, partialTick);
        }
    }

    public void drawTabs(MatrixStack matrix, int taskNumber, Quest quest, Task task) {
        int offsetWidth = (this.field_230708_k_ - 156) / 2;
        int offsetHeight = (this.field_230709_l_ - 166) / 2;
        if (task.isOngoing()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
            this.func_238474_b_(matrix, offsetWidth + (taskNumber / 7 == 0 ? -70 : 152), offsetHeight + 5 + taskNumber % 7 * 22, 171, taskNumber / 7 == 0 ? 78 : 29, 74, 22);
            if (task.icon != null) {
                this.field_230706_i_.func_175599_af().func_175042_a(task.icon, offsetWidth + (taskNumber / 7 == 0 ? -63 : 203), offsetHeight + 9 + taskNumber % 7 * 22);
            }
            if (task.getName() != null) {
                String line = I18n.func_135052_a((String)("task." + task.getName() + ".name"), (Object[])new Object[0]);
                float scaler = 0.65f;
                int drawX = Math.round((taskNumber / 7 == 0 ? -45 : 155) + offsetWidth);
                int drawY = Math.round(8 + taskNumber % 7 * 22 + offsetHeight);
                matrix.func_227860_a_();
                matrix.func_227862_a_(scaler, scaler, scaler);
                this.field_230712_o_.func_238418_a_(ITextProperties.func_240652_a_((String)line), Math.round((float)drawX / scaler), Math.round((float)drawY / scaler), Math.round(44.0f / scaler), 0);
                matrix.func_227865_b_();
            }
            if (task.isTimed() || task.progress != null) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
                this.func_238474_b_(matrix, offsetWidth + (taskNumber / 7 == 0 ? -107 : 226), offsetHeight + 10 + taskNumber % 7 * 22, 171, (taskNumber / 7 == 0 ? 142 : 130) + 24, 37, 12);
                int sec = task.getCountdown() / 20 % 60;
                String line = task.isTimed() ? task.getCountdown() / 1200 + ":" + (sec < 10 ? "0" + sec : Integer.valueOf(sec)) : task.progress.func_76341_a() + "/" + task.progress.func_76340_b();
                int textWidth = this.field_230712_o_.func_78256_a(line);
                this.field_230712_o_.getClass();
                int textHeight = 9;
                float scalerWidth = 27.0f / Float.valueOf(textWidth).floatValue();
                float scalerHeight = 10.0f / Float.valueOf(textHeight).floatValue();
                float scaler = Math.min(scalerWidth, scalerHeight);
                int drawX = Math.round((taskNumber / 7 == 0 ? -99 : 229) + offsetWidth);
                int drawY = Math.round(12 + taskNumber % 7 * 22 + offsetHeight);
                matrix.func_227860_a_();
                matrix.func_227862_a_(scaler, scaler, scaler);
                this.field_230712_o_.func_238421_b_(matrix, line, (float)Math.round((float)drawX / scaler), (float)Math.round((float)drawY / scaler), 0);
                matrix.func_227865_b_();
            }
        } else {
            int a = 48;
            if (task.failed) {
                RenderSystem.color4f((float)0.6328125f, (float)0.1484375f, (float)0.1484375f, (float)1.0f);
            } else if (task.completed) {
                RenderSystem.color4f((float)0.39453125f, (float)0.6640625f, (float)0.390625f, (float)1.0f);
                a = 0;
            } else if (task.canStart(quest)) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                a = 24;
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                a = 72;
            }
            this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
            this.func_238474_b_(matrix, offsetWidth + (taskNumber / 7 == 0 ? -25 : 152), offsetHeight + 5 + taskNumber % 7 * 22, 171, taskNumber / 7 == 0 ? 100 : 51, 29, 22);
            if (task.icon != null) {
                this.field_230706_i_.func_175599_af().func_175042_a(task.icon, offsetWidth + (taskNumber / 7 == 0 ? -18 : 158), offsetHeight + 9 + taskNumber % 7 * 22);
            }
            if (task.isTimed() || task.progress != null) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_230706_i_.func_110434_K().func_110577_a(QUEST);
                this.func_238474_b_(matrix, offsetWidth + (taskNumber / 7 == 0 ? -62 : 181), offsetHeight + 10 + taskNumber % 7 * 22, 171, (taskNumber / 7 == 0 ? 142 : 130) + a, 37, 12);
                String line = task.isTimed() ? task.getCountdown() / 1200 + ":" + task.getCountdown() / 20 % 60 : task.progress.func_76341_a() + "/" + task.progress.func_76340_b();
                int textWidth = this.field_230712_o_.func_78256_a(line);
                this.field_230712_o_.getClass();
                int textHeight = 9;
                float scalerWidth = 27.0f / Float.valueOf(textWidth).floatValue();
                float scalerHeight = 10.0f / Float.valueOf(textHeight).floatValue();
                float scaler = Math.min(scalerWidth, scalerHeight);
                int drawX = Math.round((taskNumber / 7 == 0 ? -54 : 184) + offsetWidth);
                int drawY = Math.round(12 + taskNumber % 7 * 22 + offsetHeight);
                matrix.func_227860_a_();
                matrix.func_227862_a_(scaler, scaler, scaler);
                this.field_230712_o_.func_238421_b_(matrix, line, (float)Math.round((float)drawX / scaler), (float)Math.round((float)drawY / scaler), 0);
                matrix.func_227865_b_();
            }
        }
    }

    public boolean func_231177_au__() {
        return false;
    }
}

