/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.paleimitations.schoolsofmagic.client.ClientProxy;
import com.paleimitations.schoolsofmagic.common.config.Config;
import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.IMagicData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.MagicData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.MagicDataProvider;
import com.paleimitations.schoolsofmagic.common.items.WandBaseItem;
import com.paleimitations.schoolsofmagic.common.network.PacketHandler;
import com.paleimitations.schoolsofmagic.common.network.SwapSpellChargePacket;
import com.paleimitations.schoolsofmagic.common.network.SwapSpellSlotPacket;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasDuration;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasMultiUses;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="schoolsofmagic", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SpellGui
extends AbstractGui {
    private final int texWidth = 114;
    private final int texHeight = 114;
    private static final ResourceLocation SPELL_CHARGE_ICONS = new ResourceLocation("schoolsofmagic", "textures/gui/spell_charge_icons.png");
    private static final ResourceLocation MAGICIAN_HUD_ICONS = new ResourceLocation("schoolsofmagic", "textures/gui/magician_level_hud_elements.png");
    private int animationTick;
    private int prevSlot;
    private int animateSlot;
    private Minecraft minecraft;
    private FontRenderer font;

    public SpellGui(Minecraft minecraft) {
        this.minecraft = minecraft;
        this.font = minecraft.field_71466_p;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderSpellRing(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && this.minecraft.field_71439_g != null) {
            this.render(event.getMatrixStack(), event.getPartialTicks());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        if (ClientProxy.SPELL.func_151470_d() && player.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY).isPresent()) {
            IMagicData data = (IMagicData)player.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY).orElseThrow(IllegalStateException::new);
            float dW = (float)event.getScrollDelta();
            if (dW > 0.0f) {
                dW = 1.0f;
            }
            if (dW < 0.0f) {
                dW = -1.0f;
            }
            if (dW != 0.0f && player.func_184614_ca().func_77973_b() instanceof WandBaseItem) {
                if (player.func_225608_bj_()) {
                    int a;
                    int j;
                    int level;
                    Spell spell = data.getCurrentSpell();
                    if (spell != null && (level = MathHelper.func_76125_a((int)(j = spell.currentSpellChargeLevel + (int)dW), (int)spell.minSpellChargeLevel, (int)(a = data.getLargestChargeLevel()))) != spell.currentSpellChargeLevel) {
                        PacketHandler.INSTANCE.sendToServer((Object)new SwapSpellChargePacket(player.func_145782_y(), data.getCurrentSpellSlot(), level));
                        spell.currentSpellChargeLevel = level;
                    }
                } else {
                    int j;
                    int a = data.getSpellSlots(player.func_184614_ca());
                    for (j = data.getCurrentSpellSlot() + (int)dW; j < 0; j += a) {
                    }
                    int i = j % a;
                    PacketHandler.INSTANCE.sendToServer((Object)new SwapSpellSlotPacket(player.func_145782_y(), i));
                    data.setCurrentSpellSlot(i);
                }
                player.field_71071_by.func_195409_a((double)(-dW));
            }
        }
    }

    public void render(MatrixStack matrix, float partialTicks) {
        ItemStack stack;
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        ItemStack itemStack = stack = player != null ? player.func_184614_ca() : ItemStack.field_190927_a;
        if (player.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY).isPresent()) {
            IMagicData data = (IMagicData)player.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY).orElseThrow(IllegalStateException::new);
            if (stack.func_77973_b() instanceof WandBaseItem) {
                int screenWidth = this.minecraft.func_228018_at_().func_198107_o();
                int screenHeight = this.minecraft.func_228018_at_().func_198087_p();
                int xPos = screenWidth / 2 - 57;
                int yPos = screenHeight / 2 - 57;
                if (!ClientProxy.SPELL.func_151470_d()) {
                    if (data.getCurrentSpell() != null) {
                        Spell spell = data.getCurrentSpell();
                        int i = spell.currentSpellChargeLevel;
                        boolean usable = i >= spell.minSpellChargeLevel;
                        float countdown = data.getCountdowns()[i];
                        float maxCountdown = MagicData.MAX_COUNTDOWNS[i];
                        float cooldown = (maxCountdown - countdown) / maxCountdown;
                        this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                        switch (Config.getSpellGuiPostion()) {
                            case BOTTOM_LEFT: {
                                this.func_238474_b_(matrix, 0, screenHeight - 38, 0, 77, 38, 38);
                                this.drawSpellIcon(matrix, 19, screenHeight - 35 + 16, data.getCurrentSpell(), 1.0f);
                                break;
                            }
                            case BOTTOM_RIGHT: {
                                this.func_238474_b_(matrix, screenWidth - 38, screenHeight - 38, 38, 77, 38, 38);
                                this.drawSpellIcon(matrix, screenWidth - 35 + 16, screenHeight - 35 + 16, data.getCurrentSpell(), 1.0f);
                                break;
                            }
                            case TOP_LEFT: {
                                this.func_238474_b_(matrix, 0, 0, 0, 39, 38, 38);
                                this.drawSpellIcon(matrix, 19, 19, data.getCurrentSpell(), 1.0f);
                                break;
                            }
                            case TOP_RIGHT: {
                                this.func_238474_b_(matrix, screenWidth - 38, 0, 38, 39, 38, 38);
                                this.drawSpellIcon(matrix, screenWidth - 35 + 16, 19, data.getCurrentSpell(), 1.0f);
                                break;
                            }
                            case LEFT: {
                                this.func_238474_b_(matrix, 0, screenHeight / 2 - 19, 87, 66, 54, 45);
                                this.drawSpellIcon(matrix, 27, screenHeight / 2 - 19 + 3 + 16, data.getCurrentSpell(), 1.0f);
                                break;
                            }
                            case RIGHT: {
                                this.func_238474_b_(matrix, screenWidth - 54, screenHeight / 2 - 19, 87, 66, 54, 45);
                                this.drawSpellIcon(matrix, screenWidth - 54 + 11 + 16, screenHeight / 2 - 19 + 3 + 16, data.getCurrentSpell(), 1.0f);
                            }
                        }
                        matrix.func_227860_a_();
                        float scale = 0.65f;
                        switch (Config.getSpellGuiPostion()) {
                            case BOTTOM_LEFT: {
                                matrix.func_227861_a_((double)(38.0f * (1.0f - scale) / 2.0f), (double)((float)screenHeight - 38.0f * (1.0f + scale)), 0.0);
                                break;
                            }
                            case BOTTOM_RIGHT: {
                                matrix.func_227861_a_((double)((float)screenWidth - 38.0f * (1.0f + scale) / 2.0f), (double)((float)screenHeight - 38.0f * (1.0f + scale)), 0.0);
                                break;
                            }
                            case TOP_LEFT: {
                                matrix.func_227861_a_((double)(38.0f * (1.0f - scale) / 2.0f), 38.0, 0.0);
                                break;
                            }
                            case TOP_RIGHT: {
                                matrix.func_227861_a_((double)((float)screenWidth - 38.0f * (1.0f + scale) / 2.0f), 38.0, 0.0);
                                break;
                            }
                            case LEFT: {
                                matrix.func_227861_a_((double)(27.0f - 38.0f * scale / 2.0f), (double)((float)(screenHeight / 2 - 19) - 38.0f * scale), 0.0);
                                break;
                            }
                            case RIGHT: {
                                matrix.func_227861_a_((double)((float)screenWidth - 27.0f - 38.0f * scale / 2.0f), (double)((float)(screenHeight / 2 - 19) - 38.0f * scale), 0.0);
                            }
                        }
                        matrix.func_227862_a_(scale, scale, scale);
                        this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                        this.func_238474_b_(matrix, 0, 0, 38, 0, 38, 38);
                        this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                        this.func_238474_b_(matrix, 3, 3, i % 3 * 32 + 96, i / 3 * 32, 32, 32);
                        this.func_238474_b_(matrix, 3, 3 + Math.round(32.0f * countdown / maxCountdown), i % 3 * 32, i / 3 * 32 + (usable ? 0 : 96) + Math.round(32.0f * countdown / maxCountdown), 32, Math.round(32.0f * cooldown));
                        int a = data.getMaxCharges(i, data.getLevel());
                        int b = data.getCharges()[i];
                        block36: for (int j = 1; j <= a; ++j) {
                            switch (Config.getSpellGuiPostion()) {
                                case BOTTOM_LEFT: 
                                case BOTTOM_RIGHT: 
                                case LEFT: 
                                case RIGHT: {
                                    this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                                    this.func_238474_b_(matrix, 9, -1 - 16 * j, 136, 0, 20, 20);
                                    this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                                    if (j > b) continue block36;
                                    if (usable) {
                                        this.func_238474_b_(matrix, 12, 3 - 16 * j, 14 * i, 192, 14, 14);
                                        continue block36;
                                    }
                                    this.func_238474_b_(matrix, 12, 3 - 16 * j, 0, 220, 14, 14);
                                    continue block36;
                                }
                                case TOP_LEFT: 
                                case TOP_RIGHT: {
                                    this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                                    this.func_238474_b_(matrix, 9, 19 + 16 * j, 96, 0, 20, 20);
                                    this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                                    if (j > b) continue block36;
                                    if (usable) {
                                        this.func_238474_b_(matrix, 12, 21 + 16 * j, 14 * i, 192, 14, 14);
                                        continue block36;
                                    }
                                    this.func_238474_b_(matrix, 12, 21 + 16 * j, 0, 220, 14, 14);
                                }
                            }
                        }
                        matrix.func_227865_b_();
                        if (spell instanceof IHasDuration && ((IHasDuration)((Object)spell)).getDefaultDuration(spell.lastSpellChargeLevel) > 0 || spell.getUsesPerCharge(spell.lastSpellChargeLevel) >= 100) {
                            int width = spell instanceof IHasDuration ? Math.round((float)((IHasDuration)((Object)spell)).getDuration() / (float)((IHasDuration)((Object)spell)).getDefaultDuration(spell.lastSpellChargeLevel) * 64.0f) : Math.round((float)spell.remainingUses / (spell instanceof IHasMultiUses ? (float)((IHasMultiUses)((Object)spell)).getMaxUses(spell.lastSpellChargeLevel) : (float)spell.getUsesPerCharge(spell.lastSpellChargeLevel)) * 64.0f);
                            matrix.func_227860_a_();
                            float scaleDur = 0.65f;
                            switch (Config.getSpellGuiPostion()) {
                                case BOTTOM_LEFT: {
                                    matrix.func_227861_a_(40.0, (double)((float)screenHeight - 9.0f - 12.0f * scaleDur / 2.0f), 0.0);
                                    matrix.func_227862_a_(scaleDur, scaleDur, scaleDur);
                                    this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                                    this.func_238474_b_(matrix, 0, 0, 101, 49, 72, 12);
                                    this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                                    this.func_238474_b_(matrix, 4, 4, 101, 151 + 4 * spell.currentSpellChargeLevel, width, 4);
                                    matrix.func_227865_b_();
                                    break;
                                }
                                case BOTTOM_RIGHT: {
                                    matrix.func_227861_a_((double)((float)screenWidth - 40.0f - 72.0f * scaleDur), (double)((float)screenHeight - 9.0f - 12.0f * scaleDur / 2.0f), 0.0);
                                    matrix.func_227862_a_(scaleDur, scaleDur, scaleDur);
                                    this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                                    this.func_238474_b_(matrix, 0, 0, 101, 49, 72, 12);
                                    this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                                    this.func_238474_b_(matrix, 4, 4, 101, 151 + 4 * spell.currentSpellChargeLevel, width, 4);
                                    matrix.func_227865_b_();
                                    break;
                                }
                                case TOP_LEFT: {
                                    matrix.func_227861_a_(40.0, (double)(19.0f - 12.0f * scaleDur / 2.0f), 0.0);
                                    matrix.func_227862_a_(scaleDur, scaleDur, scaleDur);
                                    this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                                    this.func_238474_b_(matrix, 0, 0, 101, 49, 72, 12);
                                    this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                                    this.func_238474_b_(matrix, 4, 4, 101, 151 + 4 * spell.currentSpellChargeLevel, width, 4);
                                    matrix.func_227865_b_();
                                    break;
                                }
                                case TOP_RIGHT: {
                                    matrix.func_227861_a_((double)((float)screenWidth - 40.0f - 72.0f * scaleDur), (double)(19.0f - 12.0f * scaleDur / 2.0f), 0.0);
                                    matrix.func_227862_a_(scaleDur, scaleDur, scaleDur);
                                    this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                                    this.func_238474_b_(matrix, 0, 0, 101, 49, 72, 12);
                                    this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                                    this.func_238474_b_(matrix, 4, 4, 101, 151 + 4 * spell.currentSpellChargeLevel, width, 4);
                                    matrix.func_227865_b_();
                                    break;
                                }
                                case LEFT: {
                                    matrix.func_227861_a_((double)(27.0f - 12.0f * scaleDur / 2.0f), (double)(screenHeight / 2 + 28), 0.0);
                                    matrix.func_227862_a_(scaleDur, scaleDur, scaleDur);
                                    this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                                    this.func_238474_b_(matrix, 0, 0, 189, 21, 12, 72);
                                    this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                                    this.func_238474_b_(matrix, 4, 4, 128 + 4 * spell.currentSpellChargeLevel, 189, 4, width);
                                    matrix.func_227865_b_();
                                    break;
                                }
                                case RIGHT: {
                                    matrix.func_227861_a_((double)((float)screenWidth - 27.0f - 12.0f * scaleDur / 2.0f), (double)(screenHeight / 2 + 28), 0.0);
                                    matrix.func_227862_a_(scaleDur, scaleDur, scaleDur);
                                    this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                                    this.func_238474_b_(matrix, 0, 0, 189, 21, 12, 72);
                                    this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                                    this.func_238474_b_(matrix, 4, 4, 128 + 4 * spell.currentSpellChargeLevel, 189, 4, width);
                                    matrix.func_227865_b_();
                                }
                            }
                        } else if (spell.getUsesPerCharge(spell.lastSpellChargeLevel) > 0) {
                            String remUses = String.valueOf(spell.remainingUses);
                            this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                            float f = 11.0f / (float)this.font.func_78256_a(remUses);
                            this.font.getClass();
                            float scaleUses = Math.min(f, 10.0f / 9.0f);
                            switch (Config.getSpellGuiPostion()) {
                                case BOTTOM_LEFT: {
                                    this.func_238474_b_(matrix, 40, screenHeight - 29, 167, 21, 21, 20);
                                    matrix.func_227860_a_();
                                    double d = 51.0f - (float)this.font.func_78256_a(remUses) / 2.0f;
                                    float f2 = (float)screenHeight - 18.0f;
                                    this.font.getClass();
                                    matrix.func_227861_a_(d, (double)(f2 - 9.0f / 2.0f), 0.0);
                                    break;
                                }
                                case BOTTOM_RIGHT: {
                                    this.func_238474_b_(matrix, screenWidth - 40 - 21, screenHeight - 29, 167, 21, 21, 20);
                                    matrix.func_227860_a_();
                                    double d = (float)screenWidth - 50.0f - (float)this.font.func_78256_a(remUses) / 2.0f;
                                    float f3 = (float)screenHeight - 18.0f;
                                    this.font.getClass();
                                    matrix.func_227861_a_(d, (double)(f3 - 9.0f / 2.0f), 0.0);
                                    break;
                                }
                                case LEFT: {
                                    this.func_238474_b_(matrix, 17, screenHeight / 2 + 28, 167, 21, 21, 20);
                                    matrix.func_227860_a_();
                                    double d = 28.0f - (float)this.font.func_78256_a(remUses) / 2.0f;
                                    float f4 = (float)screenHeight / 2.0f + 28.0f + 11.0f;
                                    this.font.getClass();
                                    matrix.func_227861_a_(d, (double)(f4 - 9.0f / 2.0f), 0.0);
                                    break;
                                }
                                case RIGHT: {
                                    this.func_238474_b_(matrix, screenWidth - 10 - 27, screenHeight / 2 + 28, 167, 21, 21, 20);
                                    matrix.func_227860_a_();
                                    double d = (float)(screenWidth - 27) - (float)this.font.func_78256_a(remUses) / 2.0f;
                                    float f5 = (float)screenHeight / 2.0f + 28.0f + 11.0f;
                                    this.font.getClass();
                                    matrix.func_227861_a_(d, (double)(f5 - 9.0f / 2.0f), 0.0);
                                    break;
                                }
                                case TOP_LEFT: {
                                    this.func_238474_b_(matrix, 40, 9, 167, 21, 21, 20);
                                    matrix.func_227860_a_();
                                    double d = 51.0f - (float)this.font.func_78256_a(remUses) / 2.0f;
                                    this.font.getClass();
                                    matrix.func_227861_a_(d, (double)(20.0f - 9.0f / 2.0f), 0.0);
                                    break;
                                }
                                case TOP_RIGHT: {
                                    this.func_238474_b_(matrix, screenWidth - 40 - 21, 9, 167, 21, 21, 20);
                                    matrix.func_227860_a_();
                                    double d = (float)screenWidth - 50.0f - (float)this.font.func_78256_a(remUses) / 2.0f;
                                    this.font.getClass();
                                    matrix.func_227861_a_(d, (double)(20.0f - 9.0f / 2.0f), 0.0);
                                }
                            }
                            matrix.func_227862_a_(scaleUses, scaleUses, scaleUses);
                            this.font.func_238421_b_(matrix, remUses, 0.0f, 0.0f, Color.BLACK.getRGB());
                            this.font.func_238421_b_(matrix, remUses, 0.0f, -1.0f, 0xFFFFFF);
                            matrix.func_227865_b_();
                        }
                    }
                } else {
                    float angle;
                    int maxSpellCharge = data.getLargestChargeLevel() + 1;
                    int magicianHUDX = screenWidth - 29;
                    int magicianHUDY = 0;
                    this.minecraft.func_110434_K().func_110577_a(MAGICIAN_HUD_ICONS);
                    this.func_238474_b_(matrix, magicianHUDX, magicianHUDY, (maxSpellCharge - 1) * 24, 128, 24, 128);
                    int magicianLevelHeight = Math.round(Math.min(1.0f, ((Float)data.getMagicianXPToNextLevel().func_76341_a()).floatValue() / ((Float)data.getMagicianXPToNextLevel().func_76340_b()).floatValue()) * 102.0f);
                    this.minecraft.func_110434_K().func_110577_a(MAGICIAN_HUD_ICONS);
                    this.func_238474_b_(matrix, magicianHUDX + 3, magicianHUDY, (maxSpellCharge - 1) * 19 + 71, 0, 18, magicianLevelHeight);
                    int magicianLvl = data.getLevel();
                    this.minecraft.func_110434_K().func_110577_a(MAGICIAN_HUD_ICONS);
                    if (magicianLvl < 10) {
                        this.func_238474_b_(matrix, magicianHUDX + 9, magicianHUDY + 105, magicianLvl * 7, maxSpellCharge * 10, 7, 9);
                    } else {
                        this.func_238474_b_(matrix, magicianHUDX + 5, magicianHUDY + 105, magicianLvl / 10 * 7, maxSpellCharge * 10, 7, 9);
                        this.func_238474_b_(matrix, magicianHUDX + 12, magicianHUDY + 105, magicianLvl % 10 * 7, maxSpellCharge * 10, 7, 9);
                    }
                    this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                    this.func_238474_b_(matrix, xPos, yPos, 0, 115, 114, 114);
                    float chargeScale = Math.min((float)screenHeight * 0.8f / (float)maxSpellCharge / 38.0f, 1.0f);
                    matrix.func_227860_a_();
                    matrix.func_227861_a_(0.0, (double)((float)screenHeight / 2.0f), 0.0);
                    matrix.func_227862_a_(chargeScale, chargeScale, chargeScale);
                    matrix.func_227861_a_(0.0, (double)(-(38.0f * (float)maxSpellCharge) / 2.0f), 0.0);
                    for (int i = 0; i < maxSpellCharge; ++i) {
                        boolean hasSpell = data.getCurrentSpell() != null;
                        boolean isSelected = hasSpell && data.getCurrentSpell().currentSpellChargeLevel == i;
                        boolean usable = hasSpell && i >= data.getCurrentSpell().minSpellChargeLevel;
                        float countdown = data.getCountdowns()[i];
                        float maxCountdown = MagicData.MAX_COUNTDOWNS[i];
                        float cooldown = (maxCountdown - countdown) / maxCountdown;
                        this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                        this.func_238474_b_(matrix, 0, 38 * i, isSelected ? 0 : 38, 0, 38, 38);
                        int a = data.getMaxCharges(i, data.getLevel());
                        int b = data.getCharges()[i];
                        for (int j = 1; j <= a; ++j) {
                            this.minecraft.func_110434_K().func_110577_a(this.getTexture(player.func_184614_ca()));
                            this.func_238474_b_(matrix, 16 * j + 19, 38 * i + 9, 76, 0, 20, 20);
                            this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                            if (j > b) continue;
                            if (usable) {
                                this.func_238474_b_(matrix, 16 * j + 21, 38 * i + 12, 14 * i, 192 + (isSelected ? 0 : 14), 14, 14);
                                continue;
                            }
                            this.func_238474_b_(matrix, 16 * j + 21, 38 * i + 12, 0, 220, 14, 14);
                        }
                        this.minecraft.func_110434_K().func_110577_a(SPELL_CHARGE_ICONS);
                        this.func_238474_b_(matrix, 3, 38 * i + 3, i % 3 * 32 + 96, i / 3 * 32, 32, 32);
                        this.func_238474_b_(matrix, 3, 38 * i + 3 + Math.round(32.0f * countdown / maxCountdown), i % 3 * 32, i / 3 * 32 + (usable ? 0 : 96) + Math.round(32.0f * countdown / maxCountdown), 32, Math.round(32.0f * cooldown));
                    }
                    matrix.func_227865_b_();
                    if (data.getCurrentSpell() != null) {
                        String s = I18n.func_135052_a((String)("spell." + data.getCurrentSpell().getName() + ".name"), (Object[])new Object[0]);
                        this.font.func_238421_b_(matrix, s, (float)(screenWidth / 2 - this.font.func_78256_a(s) / 2), (float)(yPos - 25), Color.BLACK.getRGB());
                        this.font.func_238421_b_(matrix, s, (float)(screenWidth / 2 - this.font.func_78256_a(s) / 2), (float)(yPos - 26), 0xFFFFFF);
                    }
                    if (this.animationTick > 0) {
                        --this.animationTick;
                    }
                    if (this.prevSlot != data.getCurrentSpellSlot()) {
                        if (this.animationTick < 60) {
                            this.animationTick += 30;
                        }
                        this.animateSlot = this.prevSlot;
                    }
                    if (this.animationTick == 0) {
                        this.animateSlot = data.getCurrentSpellSlot();
                    }
                    this.prevSlot = data.getCurrentSpellSlot();
                    int spells = data.getSpellSlots(player.func_184614_ca());
                    float difference = this.animateSlot - data.getCurrentSpellSlot();
                    if (Math.abs(difference) >= (float)(spells - 1) && difference < 0.0f) {
                        difference = this.animateSlot - data.getCurrentSpellSlot() + spells;
                    }
                    float f = angle = this.animateSlot == data.getCurrentSpellSlot() ? (float)data.getCurrentSpellSlot() / (float)spells * 360.0f : ((float)data.getCurrentSpellSlot() + difference * ((float)this.animationTick + partialTicks) / 30.0f) / (float)spells * 360.0f;
                    if (difference > 0.0f && Math.abs(difference) >= (float)(spells - 1)) {
                        difference = this.animateSlot - data.getCurrentSpellSlot() - spells;
                        angle = ((float)data.getCurrentSpellSlot() + difference * ((float)this.animationTick + partialTicks) / 30.0f) / (float)spells * 360.0f;
                    }
                    for (int i = 0; i < spells; ++i) {
                        int radius = 54;
                        Spell spell = data.getSpell(i);
                        matrix.func_227860_a_();
                        matrix.func_227861_a_((double)((float)screenWidth / 2.0f), (double)((float)screenHeight / 2.0f - 1.5f), 0.0);
                        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-angle + (float)i / (float)spells * 360.0f));
                        float scale = 1.0f;
                        if (spells == 9) {
                            scale = 0.91f;
                        }
                        if (spells == 10) {
                            scale = 0.85f;
                        }
                        if (spells == 11) {
                            scale = 0.79f;
                        }
                        if (spells == 12) {
                            scale = 0.74f;
                        }
                        if (spells == 13) {
                            scale = 0.69f;
                        }
                        if (spells == 14) {
                            scale = 0.64f;
                        }
                        if (spells == 15) {
                            scale = 0.6f;
                        }
                        if (spells == 16) {
                            scale = 0.56f;
                        }
                        if (spells == 17) {
                            scale = 0.52f;
                        }
                        if (spells == 18) {
                            scale = 0.48f;
                        }
                        if (spells == 19) {
                            scale = 0.46f;
                        }
                        if (spells == 20) {
                            scale = 0.45f;
                        }
                        this.drawSpellSlot(matrix, 0, -radius, player.func_184614_ca(), scale);
                        if (spell != null) {
                            this.drawSpellIcon(matrix, 0, -radius, spell, scale);
                        }
                        matrix.func_227865_b_();
                    }
                    RenderSystem.pushMatrix();
                    RenderSystem.translatef((float)(screenWidth / 2), (float)(screenHeight / 2), (float)0.0f);
                    RenderSystem.rotatef((float)-45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    RenderSystem.scalef((float)3.0f, (float)3.0f, (float)3.0f);
                    RenderSystem.translatef((float)-8.0f, (float)-8.0f, (float)0.0f);
                    this.drawItemStack(player.func_184614_ca(), 0, 0);
                    RenderSystem.popMatrix();
                }
            }
        }
    }

    public ResourceLocation getTexture(ItemStack wand) {
        return new ResourceLocation("schoolsofmagic", "textures/gui/hud_elements_gold.png");
    }

    public void drawSpellIcon(MatrixStack matrix, int xPos, int yPos, Spell spell, float scale) {
        if (spell != null) {
            matrix.func_227860_a_();
            matrix.func_227862_a_(scale, scale, scale);
            this.minecraft.func_110434_K().func_110577_a(spell.getSpellIcon());
            SpellGui.func_238463_a_((MatrixStack)matrix, (int)(Math.round((float)xPos / scale) - 16), (int)(Math.round((float)yPos / scale) - 16), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            matrix.func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawItemStack(ItemStack stack, int x, int y) {
        ItemRenderer itemRender = this.minecraft.func_175599_af();
        if (stack != null) {
            itemRender.field_77023_b = 100.0f;
            itemRender.func_180450_b(stack, x, y);
            itemRender.field_77023_b = 0.0f;
        }
    }

    public void drawSpellSlot(MatrixStack matrix, int xPos, int yPos, ItemStack wand, float scale) {
        this.minecraft.func_110434_K().func_110577_a(this.getTexture(wand));
        matrix.func_227860_a_();
        matrix.func_227862_a_(scale, scale, scale);
        this.func_238474_b_(matrix, Math.round((float)xPos / scale) - 19, Math.round((float)yPos / scale) - 19, 38, 0, 38, 38);
        matrix.func_227865_b_();
    }
}

