/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.client.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookDataProvider;
import com.paleimitations.schoolsofmagic.common.tileentities.PodiumTileEntity;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;

public class GrimoireModel
extends EntityModel<Entity> {
    private final ModelRenderer book_bone;
    private final ModelRenderer front_cover_bone;
    private final ModelRenderer back_cover_bone;
    private final ModelRenderer page_bone;

    public GrimoireModel() {
        this.field_78090_t = 320;
        this.field_78089_u = 320;
        this.book_bone = new ModelRenderer((Model)this);
        this.book_bone.func_78793_a(8.0f, 24.0f, 0.0f);
        this.book_bone.func_78784_a(0, 0).func_228303_a_(-14.0f, -86.0f, 0.0f, 12.0f, 86.0f, 8.0f, 0.0f, false);
        this.front_cover_bone = new ModelRenderer((Model)this);
        this.front_cover_bone.func_78793_a(-11.0f, 0.0f, 3.0f);
        this.book_bone.func_78792_a(this.front_cover_bone);
        this.front_cover_bone.func_78784_a(188, 0).func_228303_a_(-59.0f, -85.5f, 0.9f, 62.0f, 85.0f, 2.0f, 0.0f, false);
        this.front_cover_bone.func_78784_a(55, 0).func_228303_a_(-52.0f, -83.6f, -7.0f, 55.0f, 81.0f, 8.0f, 0.0f, false);
        this.back_cover_bone = new ModelRenderer((Model)this);
        this.back_cover_bone.func_78793_a(-5.0f, 0.0f, 3.0f);
        this.book_bone.func_78792_a(this.back_cover_bone);
        this.back_cover_bone.func_78784_a(188, 100).func_228303_a_(-3.0f, -85.5f, 0.9f, 62.0f, 85.0f, 2.0f, 0.0f, false);
        this.back_cover_bone.func_78784_a(55, 100).func_228303_a_(-3.0f, -83.5f, -7.0f, 55.0f, 81.0f, 8.0f, 0.0f, false);
        this.page_bone = new ModelRenderer((Model)this);
        this.page_bone.func_78793_a(-3.0f, 0.0f, -7.0f);
        this.back_cover_bone.func_78792_a(this.page_bone);
        this.setRotationAngle(this.page_bone, 0.0f, 1.6144f, 0.0f);
        this.page_bone.func_78784_a(0, 200).func_228303_a_(0.0f, -83.5f, 0.0f, 55.0f, 81.0f, 0.0f, 0.0f, false);
    }

    public void func_225597_a_(Entity p_225597_1_, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void render(PodiumTileEntity te, int tick, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float progress = 0.0f;
        this.page_bone.field_78806_j = false;
        PodiumTileEntity.BookState bookstate = te.bookState;
        switch (te.bookState) {
            case CLOSED: {
                this.back_cover_bone.field_78796_g = (float)Math.toRadians(90.0);
                this.front_cover_bone.field_78796_g = (float)Math.toRadians(-90.0);
                this.book_bone.field_78808_h = (float)Math.toRadians(90.0);
                this.book_bone.field_78795_f = (float)Math.toRadians(-90.0);
                break;
            }
            case OPEN_BOOK: {
                progress = (float)tick / (float)bookstate.getAnimationLength();
                this.back_cover_bone.field_78796_g = (float)Math.toRadians(90.0 - 90.0 * (double)progress);
                this.front_cover_bone.field_78796_g = (float)Math.toRadians(-90.0 + 90.0 * (double)progress);
                this.book_bone.field_78808_h = (float)Math.toRadians(90.0 - 90.0 * (double)progress);
                this.book_bone.field_78795_f = (float)Math.toRadians(-90.0 + 90.0 * (double)progress);
                break;
            }
            case CLOSE_BOOK: {
                progress = (float)tick / (float)bookstate.getAnimationLength();
                this.back_cover_bone.field_78796_g = (float)Math.toRadians(90.0 * (double)progress);
                this.front_cover_bone.field_78796_g = (float)Math.toRadians(-90.0 * (double)progress);
                this.book_bone.field_78808_h = (float)Math.toRadians(90.0 * (double)progress);
                this.book_bone.field_78795_f = (float)Math.toRadians(-90.0 * (double)progress);
                break;
            }
            case TURN_PAGE_BACK: {
                progress = (float)tick / (float)bookstate.getAnimationLength();
                this.page_bone.field_78806_j = true;
                this.page_bone.field_78796_g = (float)Math.toRadians(180.0 - 180.0 * (double)progress);
                break;
            }
            case TURN_PAGE_FORWARD: {
                progress = (float)tick / (float)bookstate.getAnimationLength();
                this.page_bone.field_78806_j = true;
                this.page_bone.field_78796_g = (float)Math.toRadians(180.0 * (double)progress);
            }
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.16f, 0.16f, 0.16f);
        this.book_bone.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
        if (bookstate == PodiumTileEntity.BookState.OPEN) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)-0.632f, (double)-0.8f, (double)-0.0505f);
            matrixStack.func_227862_a_(0.00493f, 0.00493f, 0.00493f);
            if (te.hasBook()) {
                int subpage;
                BookData book = BookDataProvider.getBook(te.func_145831_w(), te.getItem());
                CompoundNBT nbt = te.getItem().func_196082_o();
                int page = nbt.func_74764_b("page") ? nbt.func_74762_e("page") : 0;
                int n = subpage = nbt.func_74764_b("subpage") ? nbt.func_74762_e("subpage") : 0;
                if (book != null && book.getBookPage(page) != null) {
                    book.getBookPage(page).drawPage(matrixStack, 0.0f, 0.0f, 0, 0, 0.0f, false, subpage, this.getLightColor(te));
                }
            }
            matrixStack.func_227865_b_();
        }
    }

    protected int getLightColor(TileEntity te) {
        return te.func_145831_w().func_175667_e(te.func_174877_v()) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177984_a()) : 0;
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.book_bone.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

