/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.client.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.paleimitations.schoolsofmagic.client.tileentity.GrimoireModel;
import com.paleimitations.schoolsofmagic.common.blocks.PodiumBlock;
import com.paleimitations.schoolsofmagic.common.tileentities.PodiumTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class PodiumTileEntityRenderer
extends TileEntityRenderer<PodiumTileEntity> {
    public PodiumTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(PodiumTileEntity pte, float partial, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = (Direction)pte.func_195044_w().func_177229_b((Property)PodiumBlock.HORIZONTAL_FACING);
        ItemStack item = pte.getItem();
        if (item != ItemStack.field_190927_a) {
            if (pte.hasBook()) {
                float yD;
                matrix.func_227860_a_();
                float f = direction.func_185119_l();
                float xD = 0.0f;
                float zD = 0.0f;
                float angle = 0.0f;
                float progress = (float)pte.animationTick / (float)pte.bookState.getAnimationLength();
                switch (pte.bookState) {
                    case CLOSED: {
                        yD = 0.02f;
                        if (direction == Direction.NORTH) {
                            xD = 0.3125f;
                            zD = -0.4375f;
                            break;
                        }
                        if (direction == Direction.SOUTH) {
                            xD = -0.3125f;
                            zD = 0.4375f;
                            break;
                        }
                        if (direction == Direction.EAST) {
                            xD = 0.4375f;
                            zD = 0.3125f;
                            break;
                        }
                        if (direction != Direction.WEST) break;
                        xD = -0.4375f;
                        zD = -0.3125f;
                        break;
                    }
                    case OPEN_BOOK: {
                        angle = -45.0f * progress;
                        yD = 0.02f - 0.02f * progress;
                        if (direction == Direction.NORTH) {
                            xD = 0.3125f - 0.3125f * progress;
                            zD = -0.4375f + 0.4375f * progress;
                            break;
                        }
                        if (direction == Direction.SOUTH) {
                            xD = -0.3125f + 0.3125f * progress;
                            zD = 0.4375f - 0.4375f * progress;
                            break;
                        }
                        if (direction == Direction.EAST) {
                            xD = 0.4375f - 0.4375f * progress;
                            zD = 0.3125f - 0.3125f * progress;
                            break;
                        }
                        if (direction != Direction.WEST) break;
                        xD = -0.4375f + 0.4375f * progress;
                        zD = -0.3125f + 0.3125f * progress;
                        break;
                    }
                    case CLOSE_BOOK: {
                        angle = -45.0f + 45.0f * progress;
                        yD = 0.02f * progress;
                        if (direction == Direction.NORTH) {
                            xD = 0.3125f * progress;
                            zD = -0.4375f * progress;
                            break;
                        }
                        if (direction == Direction.SOUTH) {
                            xD = -0.3125f * progress;
                            zD = 0.4375f * progress;
                            break;
                        }
                        if (direction == Direction.EAST) {
                            xD = 0.4375f * progress;
                            zD = 0.3125f * progress;
                            break;
                        }
                        if (direction != Direction.WEST) break;
                        xD = -0.4375f * progress;
                        zD = -0.3125f * progress;
                        break;
                    }
                    default: {
                        angle = -45.0f;
                        yD = (float)Math.sin((float)pte.func_145831_w().func_82737_E() / 20.0f) * 0.05f + 0.05f;
                    }
                }
                matrix.func_227861_a_(0.5 + (double)xD, (double)(1.2f + yD), 0.5 + (double)zD);
                matrix.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(f));
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(angle));
                matrix.func_227862_a_(1.0f, -1.0f, -1.0f);
                GrimoireModel model = new GrimoireModel();
                CompoundNBT nbt = pte.getItem().func_196082_o();
                RenderType renderType = RenderType.func_239268_f_((ResourceLocation)new ResourceLocation("schoolsofmagic", "textures/entity/book/" + (nbt.func_74764_b("dye") ? DyeColor.values()[nbt.func_74762_e("dye")].func_176762_d() : "tan") + ".png"));
                IVertexBuilder vertexBuilder = buffer.getBuffer(renderType);
                model.render(pte, pte.animationTick, matrix, vertexBuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                if (nbt.func_74764_b("binding")) {
                    renderType = RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("schoolsofmagic", "textures/entity/book/binding_" + nbt.func_74779_i("binding") + ".png"));
                    vertexBuilder = buffer.getBuffer(renderType);
                    model.render(pte, pte.animationTick, matrix, vertexBuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (nbt.func_74764_b("decor")) {
                    renderType = RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("schoolsofmagic", "textures/entity/book/decor_" + nbt.func_74779_i("decor") + ".png"));
                    vertexBuilder = buffer.getBuffer(renderType);
                    model.render(pte, pte.animationTick, matrix, vertexBuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (nbt.func_74764_b("decor_sec")) {
                    renderType = RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("schoolsofmagic", "textures/entity/book/decor_" + nbt.func_74779_i("decor_sec") + ".png"));
                    vertexBuilder = buffer.getBuffer(renderType);
                    model.render(pte, pte.animationTick, matrix, vertexBuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                matrix.func_227865_b_();
            } else {
                matrix.func_227860_a_();
                float i = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partial;
                matrix.func_227861_a_(0.5, 1.35 + Math.sin(i / 20.0f) * 0.075, 0.5);
                float f = direction.func_185119_l();
                matrix.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(f));
                matrix.func_227862_a_(0.65f, 0.65f, 0.65f);
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(item, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrix, buffer);
                matrix.func_227865_b_();
            }
        }
    }
}

