/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.data.TeaUtils;
import com.paleimitations.schoolsofmagic.common.registries.TeaRegistry;
import java.awt.Color;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;

public class TeaBrewResult {
    public boolean successful;
    public TeaRegistry.Tea tea1;
    public TeaRegistry.Tea tea2;
    public TeaRegistry.Tea tea3;
    public List<EffectInstance> tier1Pool;
    public List<EffectInstance> tier2Pool;
    public List<EffectInstance> tier3Pool;
    public int color;
    public String overrideName;
    public boolean isMilk = false;

    public TeaBrewResult(String tea1, String tea2, String tea3, boolean isMilk) {
        this(TeaRegistry.getTea(tea1), TeaRegistry.getTea(tea2), TeaRegistry.getTea(tea3), isMilk);
    }

    public TeaBrewResult(TeaRegistry.Tea tea1, TeaRegistry.Tea tea2, TeaRegistry.Tea tea3, boolean isMilk) {
        this.tea1 = tea1;
        this.tea2 = tea2;
        this.tea3 = tea3;
        this.isMilk = isMilk;
        this.refresh();
    }

    public void refresh() {
        this.successful = this.tea1 != null && this.tea2 != null && this.tea3 != null;
        this.tier1Pool = Lists.newArrayList();
        this.tier2Pool = Lists.newArrayList();
        this.tier3Pool = Lists.newArrayList();
        if (this.successful) {
            this.populatePools();
            this.color = TeaUtils.mixColors(this.isMilk, this.tea1, this.tea2, this.tea3);
        } else {
            this.color = this.isMilk ? Color.WHITE.getRGB() : 6854629;
        }
    }

    public TeaBrewResult(CompoundNBT nbt) {
        this.deserialize(nbt);
        this.refresh();
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("tea1", this.tea1.name);
        nbt.func_74778_a("tea2", this.tea2.name);
        nbt.func_74778_a("tea3", this.tea3.name);
        nbt.func_74757_a("successful", this.successful);
        nbt.func_74757_a("isMilk", this.isMilk);
        nbt.func_74768_a("color", this.color);
        if (this.overrideName != null && !this.overrideName.isEmpty()) {
            nbt.func_74778_a("overrideName", this.overrideName);
        }
        return nbt;
    }

    public void deserialize(CompoundNBT nbt) {
        this.tea1 = TeaRegistry.getTea(nbt.func_74779_i("tea1"));
        this.tea2 = TeaRegistry.getTea(nbt.func_74779_i("tea2"));
        this.tea3 = TeaRegistry.getTea(nbt.func_74779_i("tea3"));
        this.successful = nbt.func_74767_n("successful");
        this.isMilk = nbt.func_74767_n("isMilk");
        this.color = nbt.func_74762_e("color");
        if (nbt.func_74764_b("overrideName")) {
            this.overrideName = nbt.func_74779_i("overrideName");
        }
    }

    public TeaBrewResult setOverrideName(String name) {
        this.overrideName = name;
        return this;
    }

    public boolean hasCustomName() {
        return !this.overrideName.isEmpty();
    }

    public String getOverrideName() {
        return this.overrideName;
    }

    public int getColor() {
        return this.color;
    }

    public void populatePools() {
        this.tea1.effects.forEach(effectInstance -> {
            if (effectInstance != null) {
                int a = 1;
                if (this.tea2.effects.indexOf(effectInstance) >= 0) {
                    ++a;
                }
                if (this.tea3.effects.indexOf(effectInstance) >= 0) {
                    ++a;
                }
                switch (a) {
                    case 1: {
                        this.tier1Pool.add((EffectInstance)effectInstance);
                        break;
                    }
                    case 2: {
                        this.tier2Pool.add((EffectInstance)effectInstance);
                        break;
                    }
                    case 3: {
                        this.tier3Pool.add((EffectInstance)effectInstance);
                    }
                }
            }
        });
        this.tea2.effects.forEach(effectInstance -> {
            if (effectInstance != null) {
                int a = 1;
                if (this.tea1.effects.indexOf(effectInstance) >= 0) {
                    ++a;
                }
                if (this.tea3.effects.indexOf(effectInstance) >= 0) {
                    ++a;
                }
                switch (a) {
                    case 1: {
                        if (this.tier1Pool.contains(effectInstance)) break;
                        this.tier1Pool.add((EffectInstance)effectInstance);
                        break;
                    }
                    case 2: {
                        if (this.tier2Pool.contains(effectInstance)) break;
                        this.tier2Pool.add((EffectInstance)effectInstance);
                        break;
                    }
                    case 3: {
                        if (this.tier3Pool.contains(effectInstance)) break;
                        this.tier3Pool.add((EffectInstance)effectInstance);
                    }
                }
            }
        });
        this.tea3.effects.forEach(effectInstance -> {
            if (effectInstance != null) {
                int a = 1;
                if (this.tea1.effects.indexOf(effectInstance) >= 0) {
                    ++a;
                }
                if (this.tea2.effects.indexOf(effectInstance) >= 0) {
                    ++a;
                }
                switch (a) {
                    case 1: {
                        if (this.tier1Pool.contains(effectInstance)) break;
                        this.tier1Pool.add((EffectInstance)effectInstance);
                        break;
                    }
                    case 2: {
                        if (this.tier2Pool.contains(effectInstance)) break;
                        this.tier2Pool.add((EffectInstance)effectInstance);
                        break;
                    }
                    case 3: {
                        if (this.tier3Pool.contains(effectInstance)) break;
                        this.tier3Pool.add((EffectInstance)effectInstance);
                    }
                }
            }
        });
    }
}

