/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.blocks;

import com.paleimitations.schoolsofmagic.common.data.BookUtils;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookDataProvider;
import com.paleimitations.schoolsofmagic.common.registries.TileEntityRegistry;
import com.paleimitations.schoolsofmagic.common.tileentities.PodiumTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PodiumBlock
extends ContainerBlock {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.field_208157_J;
    public static final VoxelShape SHAPE_BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    public static final VoxelShape SHAPE_POST = Block.func_208617_a((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    public static final VoxelShape SHAPE_TOP = Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_COLLISION = VoxelShapes.func_216384_a((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_POST, SHAPE_TOP});

    public PodiumBlock(AbstractBlock.Properties p_i48446_1_) {
        super(p_i48446_1_);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        double hitX = result.func_216347_e().field_72450_a - (double)pos.func_177958_n();
        double hitY = result.func_216347_e().field_72448_b - (double)pos.func_177956_o();
        double hitZ = result.func_216347_e().field_72449_c - (double)pos.func_177952_p();
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof PodiumTileEntity) {
            PodiumTileEntity podium = (PodiumTileEntity)tileentity;
            if (podium.getItem().func_190926_b() && !player.func_184586_b(hand).func_190926_b()) {
                podium.setItem(player.func_184586_b(hand).func_77979_a(1));
                return ActionResultType.SUCCESS;
            }
            if (player.func_213453_ef() && player.func_184586_b(hand).func_190926_b() && !podium.getItem().func_190926_b()) {
                player.func_184611_a(hand, podium.getItem().func_77979_a(1));
                PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
                return ActionResultType.SUCCESS;
            }
            if (podium.hasBook() && hitY > 0.5 && world.field_72995_K) {
                BookData data = BookDataProvider.getBook(world, podium.getItem());
                switch ((Direction)blockState.func_177229_b((Property)HORIZONTAL_FACING)) {
                    case NORTH: {
                        ActionResult<ItemStack> action = hitX > 0.5 ? BookUtils.turnPage(data, podium.getItem(), false, pos) : BookUtils.turnPage(data, podium.getItem(), true, pos);
                        if (action.func_188397_a() == ActionResultType.SUCCESS) {
                            podium.setItem((ItemStack)action.func_188398_b());
                        }
                        return ActionResultType.SUCCESS;
                    }
                    case SOUTH: {
                        ActionResult<ItemStack> action = hitX > 0.5 ? BookUtils.turnPage(data, podium.getItem(), true, pos) : BookUtils.turnPage(data, podium.getItem(), false, pos);
                        if (action.func_188397_a() == ActionResultType.SUCCESS) {
                            podium.setItem((ItemStack)action.func_188398_b());
                        }
                        return ActionResultType.SUCCESS;
                    }
                    case EAST: {
                        ActionResult<ItemStack> action = hitZ > 0.5 ? BookUtils.turnPage(data, podium.getItem(), false, pos) : BookUtils.turnPage(data, podium.getItem(), true, pos);
                        if (action.func_188397_a() == ActionResultType.SUCCESS) {
                            podium.setItem((ItemStack)action.func_188398_b());
                        }
                        return ActionResultType.SUCCESS;
                    }
                    case WEST: {
                        ActionResult<ItemStack> action = hitZ > 0.5 ? BookUtils.turnPage(data, podium.getItem(), true, pos) : BookUtils.turnPage(data, podium.getItem(), false, pos);
                        if (action.func_188397_a() != ActionResultType.SUCCESS) break;
                        podium.setItem((ItemStack)action.func_188398_b());
                    }
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_196247_c(BlockState p_196247_1_, IBlockReader p_196247_2_, BlockPos p_196247_3_) {
        return SHAPE_COLLISION;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return SHAPE_COLLISION;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE_COLLISION;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return ((TileEntityType)TileEntityRegistry.PODIUM_TILE_ENTITY.get()).func_200968_a();
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            TileEntity tileentity = p_196243_2_.func_175625_s(p_196243_3_);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)p_196243_2_, (BlockPos)p_196243_3_, (IInventory)((IInventory)tileentity));
                p_196243_2_.func_175666_e(p_196243_3_, (Block)this);
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.func_185907_a(p_185471_2_.func_185800_a((Direction)p_185471_1_.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HORIZONTAL_FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)p_196258_1_.func_195992_f().func_176734_d());
    }
}

