/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.config;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="schoolsofmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Config {
    public static SpellGuiPosition getSpellGuiPostion() {
        return (SpellGuiPosition)((Object)Client.SPELL_GUI_POSITION.get());
    }

    private static boolean isResourceLocation(Object o) {
        return o instanceof String && ResourceLocation.func_208304_a((String)((String)o)) != null;
    }

    private Config() {
    }

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Common.spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Client.spec);
    }

    public static void sync() {
    }

    @SubscribeEvent
    public static void sync(ModConfig.Loading event) {
        Config.sync();
    }

    @SubscribeEvent
    public static void sync(ModConfig.Reloading event) {
        Config.sync();
    }

    public static enum SpellGuiPosition {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        LEFT,
        RIGHT,
        TOP_LEFT,
        TOP_RIGHT;

    }

    public static final class Client {
        static final ForgeConfigSpec spec;
        public static final ForgeConfigSpec.EnumValue<SpellGuiPosition> SPELL_GUI_POSITION;

        private Client() {
        }

        static {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            builder.comment("Position of the Spell casting gui");
            builder.push("spellGuiPosition");
            SPELL_GUI_POSITION = builder.defineEnum("spell_gui_position", (Enum)SpellGuiPosition.BOTTOM_LEFT);
            builder.pop();
            spec = builder.build();
        }
    }

    public static final class Common {
        static final ForgeConfigSpec spec;
        public static final ForgeConfigSpec.IntValue MAX_LEVEL;
        public static final ForgeConfigSpec.IntValue MAX_SPELL_STORAGE;
        public static final ForgeConfigSpec.IntValue SPELL_CHARGE_1_RELOAD;
        public static final ForgeConfigSpec.IntValue SPELL_CHARGE_2_RELOAD;
        public static final ForgeConfigSpec.IntValue SPELL_CHARGE_3_RELOAD;
        public static final ForgeConfigSpec.IntValue SPELL_CHARGE_4_RELOAD;
        public static final ForgeConfigSpec.IntValue SPELL_CHARGE_5_RELOAD;
        public static final ForgeConfigSpec.IntValue SPELL_CHARGE_6_RELOAD;
        public static final ForgeConfigSpec.IntValue SPELL_CHARGE_7_RELOAD;
        public static final ForgeConfigSpec.IntValue SPELL_CHARGE_8_RELOAD;
        public static final ForgeConfigSpec.IntValue SPELL_CHARGE_9_RELOAD;

        private Common() {
        }

        static {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            builder.comment("Magic system");
            builder.push("maxLevel");
            MAX_LEVEL = builder.comment("Maximum magician level").defineInRange("max_level", 36, 1, 50);
            builder.pop();
            builder.push("maxSpellStorage");
            MAX_SPELL_STORAGE = builder.comment("Maximum number of spells a magician can store").defineInRange("max_spell_storage", 20, 5, 20);
            builder.pop();
            builder.push("spellCharge1Reload");
            SPELL_CHARGE_1_RELOAD = builder.comment("The time it takes for a first level spell charge to reload in ticks").defineInRange("spell_charge_1_reload", 600, 20, 28800);
            builder.pop();
            builder.push("spellCharge2Reload");
            SPELL_CHARGE_2_RELOAD = builder.comment("The time it takes for a second level spell charge to reload in ticks").defineInRange("spell_charge_2_reload", 1200, 20, 28800);
            builder.pop();
            builder.push("spellCharge3Reload");
            SPELL_CHARGE_3_RELOAD = builder.comment("The time it takes for a third level spell charge to reload in ticks").defineInRange("spell_charge_3_reload", 1800, 20, 28800);
            builder.pop();
            builder.push("spellCharge4Reload");
            SPELL_CHARGE_4_RELOAD = builder.comment("The time it takes for a fourth level spell charge to reload in ticks").defineInRange("spell_charge_4_reload", 2400, 20, 28800);
            builder.pop();
            builder.push("spellCharge5Reload");
            SPELL_CHARGE_5_RELOAD = builder.comment("The time it takes for a fifth level spell charge to reload in ticks").defineInRange("spell_charge_5_reload", 3600, 20, 28800);
            builder.pop();
            builder.push("spellCharge6Reload");
            SPELL_CHARGE_6_RELOAD = builder.comment("The time it takes for a sixth level spell charge to reload in ticks").defineInRange("spell_charge_6_reload", 4800, 20, 28800);
            builder.pop();
            builder.push("spellCharge7Reload");
            SPELL_CHARGE_7_RELOAD = builder.comment("The time it takes for a seventh level spell charge to reload in ticks").defineInRange("spell_charge_7_reload", 6000, 20, 28800);
            builder.pop();
            builder.push("spellCharge8Reload");
            SPELL_CHARGE_8_RELOAD = builder.comment("The time it takes for a eighth level spell charge to reload in ticks").defineInRange("spell_charge_8_reload", 7200, 20, 28800);
            builder.pop();
            builder.push("spellCharge9Reload");
            SPELL_CHARGE_9_RELOAD = builder.comment("The time it takes for a ninth level spell charge to reload in ticks").defineInRange("spell_charge_9_reload", 8400, 20, 28800);
            builder.pop();
            spec = builder.build();
        }
    }
}

