/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.paleimitations.schoolsofmagic.common.registries.BlockRegistry;
import com.paleimitations.schoolsofmagic.common.registries.RecipeRegistry;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MortarRecipe
implements IRecipe<IInventory> {
    protected final int crush;
    protected final Ingredient ingredient;
    protected final Ingredient ingredientSecondary;
    protected final ItemStack result;
    protected final ItemStack resultSecondary;
    protected final ResourceLocation id;

    public MortarRecipe(ResourceLocation id, int crush, Ingredient ingredient, Ingredient ingredientSecondary, ItemStack result, ItemStack resultSecondary) {
        this.crush = crush;
        this.id = id;
        this.ingredient = ingredient;
        this.ingredientSecondary = ingredientSecondary;
        this.result = result;
        this.resultSecondary = resultSecondary;
    }

    public boolean func_77569_a(IInventory inv, World world) {
        return this.ingredient.test(inv.func_70301_a(0)) && this.ingredientSecondary.test(inv.func_70301_a(1)) || this.ingredient.test(inv.func_70301_a(1)) && this.ingredientSecondary.test(inv.func_70301_a(0)) || this.ingredient.test(inv.func_70301_a(1)) && this.ingredientSecondary.func_203189_d() && inv.func_70301_a(0).func_190926_b() || this.ingredient.test(inv.func_70301_a(0)) && this.ingredientSecondary.func_203189_d() && inv.func_70301_a(1).func_190926_b();
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.ingredient);
        if (!this.ingredientSecondary.func_203189_d()) {
            list.add((Object)this.ingredientSecondary);
        }
        return list;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public ItemStack assembleSecondary(IInventory inv) {
        return this.resultSecondary.func_77946_l();
    }

    public boolean func_194133_a(int x, int y) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ItemStack getSecondaryResultItem() {
        return this.resultSecondary;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeRegistry.MORTAR_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeRegistry.MORTAR_TYPE;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)BlockRegistry.GRANITE_MORTAR.get());
    }

    public int getCrush() {
        return this.crush;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MortarRecipe> {
        public MortarRecipe fromJson(ResourceLocation location, JsonObject json) {
            int crush = JSONUtils.func_151203_m((JsonObject)json, (String)"crush");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            Ingredient ingredientSecondary = JSONUtils.func_151204_g((JsonObject)json, (String)"ingredientSecondary") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredientSecondary")) : Ingredient.field_193370_a;
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            ItemStack itemstackSecondary = JSONUtils.func_151204_g((JsonObject)json, (String)"resultSecondary") ? ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"resultSecondary")) : ItemStack.field_190927_a;
            System.out.println("Registered Mortar Recipe:" + location.toString());
            return new MortarRecipe(location, crush, ingredient, ingredientSecondary, itemstack, itemstackSecondary);
        }

        public MortarRecipe fromNetwork(ResourceLocation location, PacketBuffer buffer) {
            int crush = buffer.readInt();
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient ingredientSecondary = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            ItemStack itemstackSecondary = buffer.func_150791_c();
            return new MortarRecipe(location, crush, ingredient, ingredientSecondary, itemstack, itemstackSecondary);
        }

        public void toNetwork(PacketBuffer buffer, MortarRecipe recipe) {
            buffer.writeInt(recipe.crush);
            recipe.ingredient.func_199564_a(buffer);
            recipe.ingredientSecondary.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
            buffer.func_150788_a(recipe.resultSecondary);
        }
    }
}

