/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.paleimitations.schoolsofmagic.common.registries.RecipeRegistry;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class MortarRecipeBuilder {
    private final int crush;
    private final Ingredient ingredient;
    private final Ingredient ingredientSecondary;
    private final Item result;
    private final int resultCount;
    private final Item resultSecondary;
    private final int resultSecondaryCount;
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private final IRecipeSerializer<?> type;

    public MortarRecipeBuilder(IRecipeSerializer<?> serializer, int crush, Ingredient ingredient, Ingredient ingredientSecondary, Item result, int resultCount, Item resultSecondary, int resultSecondaryCount) {
        this.type = serializer;
        this.crush = crush;
        this.ingredient = ingredient;
        this.ingredientSecondary = ingredientSecondary;
        this.result = result;
        this.resultCount = resultCount;
        this.resultSecondary = resultSecondary;
        this.resultSecondaryCount = resultSecondaryCount;
    }

    public static MortarRecipeBuilder crushing(int crush, Ingredient ingredient, Ingredient ingredientSecondary, Item result, int count, Item resultSecondary, int countSecondary) {
        return new MortarRecipeBuilder((IRecipeSerializer)RecipeRegistry.MORTAR_SERIALIZER.get(), crush, ingredient, ingredientSecondary, result, count, resultSecondary, countSecondary);
    }

    public static MortarRecipeBuilder crushing(int crush, Ingredient ingredient, Item result) {
        return new MortarRecipeBuilder((IRecipeSerializer)RecipeRegistry.MORTAR_SERIALIZER.get(), crush, ingredient, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStack.field_190927_a}), result, 1, Items.field_190931_a, 0);
    }

    public static MortarRecipeBuilder crushing(int crush, Ingredient ingredient, Item result, int count) {
        return new MortarRecipeBuilder((IRecipeSerializer)RecipeRegistry.MORTAR_SERIALIZER.get(), crush, ingredient, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStack.field_190927_a}), result, count, Items.field_190931_a, 0);
    }

    public MortarRecipeBuilder unlocks(String p_240503_1_, ICriterionInstance p_240503_2_) {
        this.advancement.func_200275_a(p_240503_1_, p_240503_2_);
        return this;
    }

    public void save(Consumer<IFinishedRecipe> p_240504_1_, String p_240504_2_) {
        this.save(p_240504_1_, new ResourceLocation(p_240504_2_));
    }

    public void save(Consumer<IFinishedRecipe> p_240505_1_, ResourceLocation p_240505_2_) {
        this.ensureValid(p_240505_2_);
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)p_240505_2_)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)p_240505_2_)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        p_240505_1_.accept(new Result(p_240505_2_, this.type, this.crush, this.ingredient, this.ingredientSecondary, this.result, this.resultCount, this.resultSecondary, this.resultSecondaryCount, this.advancement, new ResourceLocation(p_240505_2_.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + p_240505_2_.func_110623_a())));
    }

    private void ensureValid(ResourceLocation p_240506_1_) {
        if (this.advancement.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_240506_1_);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final int crush;
        private final Ingredient ingredient;
        private final Ingredient ingredientSecondary;
        private final Item result;
        private final int resultCount;
        private final Item resultSecondary;
        private final int resultSecondaryCount;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final IRecipeSerializer<?> type;

        public Result(ResourceLocation id, IRecipeSerializer<?> type, int crush, Ingredient ingredient, Ingredient ingredientSecondary, Item result, int resultCount, Item resultSecondary, int resultSecondaryCount, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.crush = crush;
            this.type = type;
            this.ingredient = ingredient;
            this.ingredientSecondary = ingredientSecondary;
            this.result = result;
            this.resultCount = resultCount;
            this.resultSecondary = resultSecondary;
            this.resultSecondaryCount = resultSecondaryCount;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("crush", (Number)this.crush);
            json.add("ingredient", this.ingredient.func_200304_c());
            if (!this.ingredientSecondary.func_203189_d()) {
                json.add("ingredientSecondary", this.ingredientSecondary.func_200304_c());
            }
            if (this.resultCount >= 1) {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
                jsonobject.addProperty("count", (Number)this.resultCount);
                json.add("result", (JsonElement)jsonobject);
            }
            if (this.resultSecondaryCount >= 1) {
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.resultSecondary).toString());
                jsonobject1.addProperty("count", (Number)this.resultSecondaryCount);
                json.add("resultSecondary", (JsonElement)jsonobject1);
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.type;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

