/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.paleimitations.schoolsofmagic.common.TeaBrewResult;
import com.paleimitations.schoolsofmagic.common.registries.TeaRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TeaUtils {
    public static ItemStack setTea(ItemStack stack, TeaBrewResult teaBrewResult) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_218657_a("teaBrewResult", (INBT)teaBrewResult.serialize());
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack setTea(ItemStack stack, TeaRegistry.Tea tea1, TeaRegistry.Tea tea2, TeaRegistry.Tea tea3, boolean isMilk) {
        return TeaUtils.setTea(stack, tea1.name, tea2.name, tea3.name, isMilk);
    }

    public static ItemStack setTea(ItemStack stack, String tea1, String tea2, String tea3, boolean isMilk) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a("tea1", tea1);
        nbt.func_74778_a("tea2", tea2);
        nbt.func_74778_a("tea3", tea3);
        nbt.func_74757_a("isMilk", isMilk);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static TeaBrewResult getTea(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("teaBrewResult")) {
            return new TeaBrewResult(nbt.func_74775_l("teaBrewResult"));
        }
        if (nbt.func_74764_b("tea1") && nbt.func_74764_b("tea2") && nbt.func_74764_b("tea3") && nbt.func_74764_b("isMilk")) {
            return new TeaBrewResult(nbt.func_74779_i("tea1"), nbt.func_74779_i("tea2"), nbt.func_74779_i("tea3"), nbt.func_74767_n("isMilk"));
        }
        return null;
    }

    public static int getColor(ItemStack itemStack) {
        if (itemStack.func_196082_o().func_74764_b("tea1")) {
            CompoundNBT nbt = itemStack.func_196082_o();
            return TeaUtils.mixColors(nbt.func_74767_n("isMilk"), TeaRegistry.getTea(nbt.func_74779_i("tea1")), TeaRegistry.getTea(nbt.func_74779_i("tea2")), TeaRegistry.getTea(nbt.func_74779_i("tea3")));
        }
        if (itemStack.func_196082_o().func_74764_b("teaBrewResult")) {
            return new TeaBrewResult(itemStack.func_196082_o().func_74775_l("teaBrewResult")).getColor();
        }
        return 4676607;
    }

    public static int mixColors(boolean isMilk, TeaRegistry.Tea ... teas) {
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (TeaRegistry.Tea tea : teas) {
            if (tea == null || tea.color < 0) continue;
            int k = tea.color;
            int l = 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (isMilk) {
            int k = Color.WHITE.getRGB();
            int l = 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 4676607;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static String getName(ItemStack stack, String s) {
        TeaBrewResult brew = TeaUtils.getTea(stack);
        if (brew != null && brew.tea1 != null) {
            return s + (brew.isMilk ? "milk_tea." : "tea.") + brew.tea1.name;
        }
        return s;
    }

    public static void addTooltip(ItemStack stack, List<ITextComponent> list, float v) {
        TeaBrewResult brew = TeaUtils.getTea(stack);
        if (brew != null) {
            TranslationTextComponent iformattabletextcomponent;
            List<EffectInstance> pool1 = brew.tier1Pool;
            List<EffectInstance> pool2 = brew.tier2Pool;
            List<EffectInstance> pool3 = brew.tier3Pool;
            ArrayList list1 = Lists.newArrayList();
            if (!pool1.isEmpty()) {
                iformattabletextcomponent = new TranslationTextComponent("tea_pool_1.name");
                list.add((ITextComponent)iformattabletextcomponent.func_240699_a_(TextFormatting.GOLD));
                TeaUtils.addTooltipForEffects(list, pool1, list1);
            }
            if (!pool2.isEmpty()) {
                iformattabletextcomponent = new TranslationTextComponent("tea_pool_2.name");
                list.add((ITextComponent)iformattabletextcomponent.func_240699_a_(TextFormatting.GOLD));
                TeaUtils.addTooltipForEffects(list, pool2, list1);
            }
            if (!pool3.isEmpty()) {
                iformattabletextcomponent = new TranslationTextComponent("tea_pool_3.name");
                list.add((ITextComponent)iformattabletextcomponent.func_240699_a_(TextFormatting.GOLD));
                TeaUtils.addTooltipForEffects(list, pool3, list1);
            }
        }
    }

    public static void addTooltipForEffects(List<ITextComponent> list, List<EffectInstance> effectInstances, List<Pair<Attribute, AttributeModifier>> list1) {
        for (EffectInstance effectinstance : effectInstances) {
            TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(effectinstance.func_76453_d());
            Effect effect = effectinstance.func_188419_a();
            Map map = effect.func_111186_k();
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                    list1.add((Pair<Attribute, AttributeModifier>)new Pair(entry.getKey(), (Object)attributemodifier1));
                }
            }
            if (effectinstance.func_76458_c() > 0) {
                iformattabletextcomponent = new TranslationTextComponent("potion.withAmplifier", new Object[]{iformattabletextcomponent, new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c())});
            }
            if (effectinstance.func_76459_b() > 20) {
                iformattabletextcomponent = new TranslationTextComponent("potion.withDuration", new Object[]{iformattabletextcomponent, EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)1.0f)});
            }
            list.add((ITextComponent)iformattabletextcomponent.func_240699_a_(effect.func_220303_e().func_220306_a()));
        }
    }
}

