/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.books;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.paleimitations.schoolsofmagic.common.data.books.PageElement;
import com.paleimitations.schoolsofmagic.common.registries.BookPageRegistry;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BookPage {
    public final String name;
    public final List<PageElement> elements;

    public BookPage(String name, List<PageElement> elements) {
        this.name = name;
        this.elements = elements;
        this.addPageToRegistry();
    }

    public void addPageToRegistry() {
        BookPageRegistry.PAGES.add(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPage(MatrixStack matrix, float mouseX, float mouseY, int x, int y, float zLevel, boolean isGUI, int subpage, int light) {
        for (PageElement element : this.elements) {
            if (!element.isTarget(subpage)) continue;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            element.drawElement(matrix, mouseX, mouseY, x, y, zLevel, isGUI, subpage, light);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSubPageBlank(int subpage) {
        for (PageElement element : this.elements) {
            if (!element.hasSubpage(subpage)) continue;
            return false;
        }
        return true;
    }

    public int getSubPages() {
        int i = 0;
        for (PageElement element : this.elements) {
            if (element.subpage <= i) continue;
            i = element.subpage;
        }
        return i + 1;
    }

    public String getName() {
        return this.name;
    }

    public BookPage addToList(List<BookPage> pages) {
        pages.add(this);
        return this;
    }

    public BookPage addElement(PageElement element) {
        this.elements.add(element);
        return this;
    }

    public BookPage addElements(List<PageElement> element) {
        this.elements.addAll(element);
        return this;
    }
}

