/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.books;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.data.books.BookPage;
import com.paleimitations.schoolsofmagic.common.data.books.IBookPageHolder;
import com.paleimitations.schoolsofmagic.common.data.books.PageElement;
import com.paleimitations.schoolsofmagic.common.data.books.PageElementChapterEntry;
import com.paleimitations.schoolsofmagic.common.data.books.PageElementDescription;
import com.paleimitations.schoolsofmagic.common.data.books.PageElementSpellInfo;
import com.paleimitations.schoolsofmagic.common.data.books.PageElementTitle;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;

public class BookPageChapter
extends BookPage {
    public IBookPageHolder pageHolder;
    public int page;
    public int chapterNumber = -1;

    public BookPageChapter(IBookPageHolder pageHolder) {
        super("chapter", Lists.newArrayList());
        this.pageHolder = pageHolder;
    }

    @Override
    public void addPageToRegistry() {
    }

    public void buildChapter() {
        if (this.pageHolder instanceof BookData) {
            BookPage page;
            int i;
            BookData book = (BookData)this.pageHolder;
            int chapterNumber = 0;
            int chapterPageNumber = -1;
            int chapterStart = -1;
            int chapterEnd = -1;
            for (i = 0; i < book.getBookPages().size(); ++i) {
                page = book.getBookPage(i);
                if (page instanceof BookPageChapter && chapterPageNumber == -1) {
                    ++chapterNumber;
                    if (page.equals(this)) {
                        chapterPageNumber = i;
                    }
                }
                if (chapterPageNumber <= -1 || i <= chapterPageNumber) continue;
                if (page instanceof BookPageChapter) break;
                if (chapterStart < 0) {
                    chapterStart = i;
                }
                chapterEnd = i;
            }
            if (chapterPageNumber > -1 && chapterStart > -1 && chapterEnd > -1 && chapterNumber > 0) {
                this.page = chapterPageNumber;
                this.chapterNumber = chapterNumber;
                if (this.elements.isEmpty()) {
                    String[] text = new String[]{"page.chapter.element", String.valueOf(chapterNumber)};
                    this.elements.add(new PageElementTitle(text, 72, 58, 99, 16, 0, true));
                }
                for (i = 0; i <= chapterEnd - chapterStart; ++i) {
                    int segment;
                    page = book.getBookPage(chapterStart + i);
                    String[] title = new String[2];
                    title[0] = "page.page.element";
                    String desc = "";
                    if (page != null) {
                        for (PageElement element : page.elements) {
                            if (element instanceof PageElementTitle) {
                                title = ((PageElementTitle)element).text;
                                break;
                            }
                            if (!(element instanceof PageElementSpellInfo)) continue;
                            title[0] = "spell." + ((PageElementSpellInfo)element).spell.getName() + ".name";
                            title[1] = "title.spell_page.name";
                            break;
                        }
                        for (PageElement element : page.elements) {
                            if (!(element instanceof PageElementDescription)) continue;
                            desc = ((PageElementDescription)element).description;
                            break;
                        }
                    }
                    int xi = i / (segment = 7) % 2 == 0 ? 23 : 134;
                    int yi = 65 + i % segment * 18;
                    int targeti = i / (segment * 2);
                    this.elements.add(new PageElementChapterEntry(title, desc, chapterStart + i, xi, yi, targeti, 99, 8));
                }
            }
        }
    }
}

