/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.books;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class PageElement {
    public final int x;
    public final int y;
    public final int subpage;

    public PageElement(int x, int y) {
        this(x, y, 0);
    }

    public PageElement(int x, int y, int subpage) {
        this.x = x;
        this.y = y;
        this.subpage = subpage;
    }

    public int getSubpage() {
        return this.subpage;
    }

    public boolean isTarget(int i) {
        return i == this.subpage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasSubpage(int subpage) {
        return this.subpage == subpage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawElement(MatrixStack matrixStack, float mouseX, float mouseY, int x, int y, float zLevel, boolean isGUI, int subpage, int light) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawString(FontRenderer font, String s, float x, float y, int color, MatrixStack matrix, int light) {
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        font.func_228079_a_(s, x, y, color, false, matrix.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, light);
        irendertypebuffer$impl.func_228461_a_();
    }

    public static void blit(MatrixStack matrix, int x, int y, float z, int p_238470_4_, int p_238470_5_, TextureAtlasSprite p_238470_6_, int light) {
        PageElement.innerBlit(matrix.func_227866_c_().func_227870_a_(), x, x + p_238470_4_, y, y + p_238470_5_, z, p_238470_6_.func_94209_e(), p_238470_6_.func_94212_f(), p_238470_6_.func_94206_g(), p_238470_6_.func_94210_h(), light);
    }

    public void blit(MatrixStack matrix, int x, int y, int u, int v, int width, int height, int light) {
        PageElement.blit(matrix, x, y, 0.0f, u, v, width, height, 256, 256, light);
    }

    public static void blit(MatrixStack matrix, int x, int y, float z, float u, float v, int width, int height, int imageWidth, int imageHeight, int light) {
        PageElement.innerBlit(matrix, x, x + width, y, y + height, z, width, height, u, v, imageHeight, imageWidth, light);
    }

    public static void blit(MatrixStack matrix, int x, int y, int width, int height, float p_238466_5_, float p_238466_6_, int p_238466_7_, int p_238466_8_, int p_238466_9_, int p_238466_10_, int light) {
        PageElement.innerBlit(matrix, x, x + width, y, y + height, 0.0f, p_238466_7_, p_238466_8_, p_238466_5_, p_238466_6_, p_238466_9_, p_238466_10_, light);
    }

    public static void blit(MatrixStack matrix, int p_238463_1_, int p_238463_2_, float p_238463_3_, float p_238463_4_, int p_238463_5_, int p_238463_6_, int p_238463_7_, int p_238463_8_, int light) {
        PageElement.blit(matrix, p_238463_1_, p_238463_2_, p_238463_5_, p_238463_6_, p_238463_3_, p_238463_4_, p_238463_5_, p_238463_6_, p_238463_7_, p_238463_8_, light);
    }

    private static void innerBlit(MatrixStack matrix, int x1, int x2, int y1, int y2, float z, int p_238469_6_, int p_238469_7_, float p_238469_8_, float p_238469_9_, int imageU, int imageV, int light) {
        PageElement.innerBlit(matrix.func_227866_c_().func_227870_a_(), x1, x2, y1, y2, z, (p_238469_8_ + 0.0f) / (float)imageU, (p_238469_8_ + (float)p_238469_6_) / (float)imageU, (p_238469_9_ + 0.0f) / (float)imageV, (p_238469_9_ + (float)p_238469_7_) / (float)imageV, light);
    }

    private static void innerBlit(Matrix4f matrix, int x1, int x2, int y1, int y2, float z, float u1, float u2, float v1, float v2, int light) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227852_q_);
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y2, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u1, v2).func_227886_a_(light).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u2, v2).func_227886_a_(light).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y1, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u2, v1).func_227886_a_(light).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u1, v1).func_227886_a_(light).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
        RenderSystem.defaultAlphaFunc();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawTexturedModalRect(MatrixStack matrixStack, int x, int y, int u, int v, int width, int height, float zLevel, int light) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableDepthTest();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_227852_q_);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        wr.func_227888_a_(matrix, (float)x, (float)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).func_227886_a_(light).func_181675_d();
        wr.func_227888_a_(matrix, (float)(x + width), (float)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).func_227886_a_(light).func_181675_d();
        wr.func_227888_a_(matrix, (float)(x + width), (float)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).func_227886_a_(light).func_181675_d();
        wr.func_227888_a_(matrix, (float)x, (float)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_((float)u * 0.00390625f, (float)v * 0.00390625f).func_227886_a_(light).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
        RenderSystem.defaultAlphaFunc();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawItemStack(MatrixStack matrix, ItemStack stack, int x, int y, boolean isGUI) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ItemRenderer itemRender = minecraft.func_175599_af();
        if (stack != null) {
            if (isGUI) {
                itemRender.field_77023_b = 100.0f;
                itemRender.func_180450_b(stack, x, y);
                itemRender.field_77023_b = 0.0f;
            } else {
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)x, (double)y, 0.0);
                matrix.func_227861_a_(8.0, 8.0, 0.0);
                matrix.func_227862_a_(16.0f, -16.0f, -16.0f);
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                int combinedLight = 0xF000F0;
                itemRender.func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, combinedLight, OverlayTexture.field_229196_a_, matrix, (IRenderTypeBuffer)renderType);
                matrix.func_227865_b_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderTooltip(MatrixStack p_230457_1_, ItemStack p_230457_2_, int p_230457_3_, int p_230457_4_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer font = p_230457_2_.func_77973_b().getFontRenderer(p_230457_2_);
        GuiUtils.preItemToolTip((ItemStack)p_230457_2_);
        this.renderWrappedToolTip(p_230457_1_, this.getTooltipFromItem(p_230457_2_), p_230457_3_, p_230457_4_, font == null ? minecraft.field_71466_p : font);
        GuiUtils.postItemToolTip();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipFromItem(ItemStack p_231151_1_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        return p_231151_1_.func_82840_a((PlayerEntity)minecraft.field_71439_g, (ITooltipFlag)(minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(MatrixStack p_238652_1_, ITextComponent p_238652_2_, int p_238652_3_, int p_238652_4_) {
        this.renderComponentTooltip(p_238652_1_, Arrays.asList(p_238652_2_), p_238652_3_, p_238652_4_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderComponentTooltip(MatrixStack p_243308_1_, List<ITextComponent> p_243308_2_, int p_243308_3_, int p_243308_4_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.renderWrappedToolTip(p_243308_1_, p_243308_2_, p_243308_3_, p_243308_4_, minecraft.field_71466_p);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderWrappedToolTip(MatrixStack matrixStack, List<? extends ITextProperties> tooltips, int mouseX, int mouseY, FontRenderer font) {
        Minecraft minecraft = Minecraft.func_71410_x();
        GuiUtils.drawHoveringText((MatrixStack)matrixStack, tooltips, (int)mouseX, (int)mouseY, (int)minecraft.func_228018_at_().func_198109_k(), (int)minecraft.func_228018_at_().func_198091_l(), (int)-1, (FontRenderer)font);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(MatrixStack p_238654_1_, List<? extends IReorderingProcessor> p_238654_2_, int p_238654_3_, int p_238654_4_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.renderToolTip(p_238654_1_, p_238654_2_, p_238654_3_, p_238654_4_, minecraft.field_71466_p);
    }

    /*
     * WARNING - void declaration
     */
    @OnlyIn(value=Dist.CLIENT)
    public void renderToolTip(MatrixStack p_238654_1_, List<? extends IReorderingProcessor> p_238654_2_, int p_238654_3_, int p_238654_4_, FontRenderer font) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!p_238654_2_.isEmpty()) {
            int n;
            int i = 0;
            for (IReorderingProcessor iReorderingProcessor : p_238654_2_) {
                int j = font.func_243245_a(iReorderingProcessor);
                if (j <= i) continue;
                i = j;
            }
            int i2 = p_238654_3_ + 12;
            int n2 = p_238654_4_ - 12;
            int k = 8;
            if (p_238654_2_.size() > 1) {
                k += 2 + (p_238654_2_.size() - 1) * 10;
            }
            if (i2 + i > minecraft.func_228018_at_().func_198109_k()) {
                i2 -= 28 + i;
            }
            if (n2 + k + 6 > minecraft.func_228018_at_().func_198091_l()) {
                n = minecraft.func_228018_at_().func_198091_l() - k - 6;
            }
            p_238654_1_.func_227860_a_();
            int l = -267386864;
            int i1 = 0x505000FF;
            int j1 = 1344798847;
            int k1 = 400;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            Matrix4f matrix4f = p_238654_1_.func_227866_c_().func_227870_a_();
            PageElement.fillGradient(matrix4f, bufferbuilder, i2 - 3, n - 4, i2 + i + 3, n - 3, 400, -267386864, -267386864);
            PageElement.fillGradient(matrix4f, bufferbuilder, i2 - 3, n + k + 3, i2 + i + 3, n + k + 4, 400, -267386864, -267386864);
            PageElement.fillGradient(matrix4f, bufferbuilder, i2 - 3, n - 3, i2 + i + 3, n + k + 3, 400, -267386864, -267386864);
            PageElement.fillGradient(matrix4f, bufferbuilder, i2 - 4, n - 3, i2 - 3, n + k + 3, 400, -267386864, -267386864);
            PageElement.fillGradient(matrix4f, bufferbuilder, i2 + i + 3, n - 3, i2 + i + 4, n + k + 3, 400, -267386864, -267386864);
            PageElement.fillGradient(matrix4f, bufferbuilder, i2 - 3, n - 3 + 1, i2 - 3 + 1, n + k + 3 - 1, 400, 0x505000FF, 1344798847);
            PageElement.fillGradient(matrix4f, bufferbuilder, i2 + i + 2, n - 3 + 1, i2 + i + 3, n + k + 3 - 1, 400, 0x505000FF, 1344798847);
            PageElement.fillGradient(matrix4f, bufferbuilder, i2 - 3, n - 3, i2 + i + 3, n - 3 + 1, 400, 0x505000FF, 0x505000FF);
            PageElement.fillGradient(matrix4f, bufferbuilder, i2 - 3, n + k + 2, i2 + i + 3, n + k + 3, 400, 1344798847, 1344798847);
            RenderSystem.enableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.shadeModel((int)7425);
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableTexture();
            IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            p_238654_1_.func_227861_a_(0.0, 0.0, 400.0);
            for (int l1 = 0; l1 < p_238654_2_.size(); ++l1) {
                IReorderingProcessor ireorderingprocessor1 = p_238654_2_.get(l1);
                if (ireorderingprocessor1 != null) {
                    void var9_13;
                    minecraft.field_71466_p.func_238416_a_(ireorderingprocessor1, (float)i2, (float)var9_13, -1, true, matrix4f, (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
                }
                if (l1 == 0) {
                    var9_13 += 2;
                }
                var9_13 += 10;
            }
            irendertypebuffer$impl.func_228461_a_();
            p_238654_1_.func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void fillGradient(Matrix4f p_238462_0_, BufferBuilder p_238462_1_, int p_238462_2_, int p_238462_3_, int p_238462_4_, int p_238462_5_, int p_238462_6_, int p_238462_7_, int p_238462_8_) {
        float f = (float)(p_238462_7_ >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(p_238462_7_ >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(p_238462_7_ >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(p_238462_7_ & 0xFF) / 255.0f;
        float f4 = (float)(p_238462_8_ >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(p_238462_8_ >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(p_238462_8_ >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(p_238462_8_ & 0xFF) / 255.0f;
        p_238462_1_.func_227888_a_(p_238462_0_, (float)p_238462_4_, (float)p_238462_3_, (float)p_238462_6_).func_227885_a_(f1, f2, f3, f).func_181675_d();
        p_238462_1_.func_227888_a_(p_238462_0_, (float)p_238462_2_, (float)p_238462_3_, (float)p_238462_6_).func_227885_a_(f1, f2, f3, f).func_181675_d();
        p_238462_1_.func_227888_a_(p_238462_0_, (float)p_238462_2_, (float)p_238462_5_, (float)p_238462_6_).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        p_238462_1_.func_227888_a_(p_238462_0_, (float)p_238462_4_, (float)p_238462_5_, (float)p_238462_6_).func_227885_a_(f5, f6, f7, f4).func_181675_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderComponentHoverEffect(MatrixStack p_238653_1_, @Nullable Style p_238653_2_, int p_238653_3_, int p_238653_4_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (p_238653_2_ != null && p_238653_2_.func_150210_i() != null) {
            HoverEvent hoverevent = p_238653_2_.func_150210_i();
            HoverEvent.ItemHover hoverevent$itemhover = (HoverEvent.ItemHover)hoverevent.func_240662_a_(HoverEvent.Action.field_230551_b_);
            if (hoverevent$itemhover != null) {
                this.renderTooltip(p_238653_1_, hoverevent$itemhover.func_240689_a_(), p_238653_3_, p_238653_4_);
            } else {
                HoverEvent.EntityHover hoverevent$entityhover = (HoverEvent.EntityHover)hoverevent.func_240662_a_(HoverEvent.Action.field_230552_c_);
                if (hoverevent$entityhover != null) {
                    if (minecraft.field_71474_y.field_82882_x) {
                        this.renderComponentTooltip(p_238653_1_, hoverevent$entityhover.func_240684_b_(), p_238653_3_, p_238653_4_);
                    }
                } else {
                    ITextComponent itextcomponent = (ITextComponent)hoverevent.func_240662_a_(HoverEvent.Action.field_230550_a_);
                    if (itextcomponent != null) {
                        this.renderTooltip(p_238653_1_, minecraft.field_71466_p.func_238425_b_((ITextProperties)itextcomponent, Math.max(minecraft.func_228018_at_().func_198109_k() / 2, 200)), p_238653_3_, p_238653_4_);
                    }
                }
            }
        }
    }
}

