/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.books;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.paleimitations.schoolsofmagic.common.data.books.PageElementPageButton;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PageElementChapterEntry
extends PageElementPageButton {
    public final String[] text;
    public final String desc;

    public PageElementChapterEntry(String[] text, String desc, int pageNumber, int x, int y, int target, int width, int height) {
        super(pageNumber, x, y, target, width, height);
        this.text = text;
        this.desc = desc;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawElement(MatrixStack matrixStack, float mouseX, float mouseY, int xIn, int yIn, float zLevel, boolean isGUI, int target, int light) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        matrixStack.func_227860_a_();
        mc.field_71466_p.getClass();
        int textHeight = 9;
        float scaler = (float)this.height / Float.valueOf(textHeight).floatValue();
        String end = "... " + this.pageNumber;
        int endWidth = font.func_78256_a(end);
        String t = I18n.func_135052_a((String)this.text[0], (Object[])new Object[0]);
        if (this.text.length > 1) {
            for (int i = 1; i < this.text.length; ++i) {
                if (this.text[i] == null) continue;
                t = t + " " + I18n.func_135052_a((String)this.text[i], (Object[])new Object[0]);
            }
        }
        String txt = PageElementChapterEntry.truncateStringToWidth(t, Math.round((float)this.width / scaler) - endWidth) + end;
        int drawX = this.x + xIn;
        int drawY = this.y + yIn;
        matrixStack.func_227862_a_(scaler, scaler, scaler);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.func_238421_b_(matrixStack, txt, (float)Math.round((float)drawX / scaler), (float)Math.round((float)drawY / scaler), 0);
        if (mouseX > (float)this.x && mouseX < (float)(this.x + this.width) && mouseY > (float)this.y && mouseY < (float)(this.y + this.height) && this.isTarget(this.subpage)) {
            font.func_238421_b_(matrixStack, txt, (float)Math.round((float)drawX / scaler), (float)(Math.round((float)drawY / scaler) - 1), Color.WHITE.getRGB());
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227865_b_();
        if (!this.desc.isEmpty()) {
            matrixStack.func_227860_a_();
            float descScaler = 6.0f / Float.valueOf(textHeight).floatValue();
            String descEnd = "...";
            int descEndWidth = font.func_78256_a(descEnd);
            String descTxt = PageElementChapterEntry.truncateStringToWidth(I18n.func_135052_a((String)this.desc, (Object[])new Object[0]), Math.round((float)this.width / descScaler) - descEndWidth) + descEnd;
            matrixStack.func_227862_a_(descScaler, descScaler, descScaler);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            font.func_238421_b_(matrixStack, descTxt, (float)Math.round((float)drawX / descScaler), (float)(Math.round((float)drawY / descScaler) + 10), 0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.func_227865_b_();
        }
    }

    private static String truncateStringToWidth(String str, int wrapWidth) {
        char c0;
        int k;
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        int j = 0;
        for (k = 0; k < str.length() && (j += font.func_78256_a(String.valueOf(c0 = str.charAt(k)))) <= wrapWidth; ++k) {
        }
        return str.substring(0, k);
    }
}

