/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.books;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.paleimitations.schoolsofmagic.client.data.BookTextManager;
import com.paleimitations.schoolsofmagic.common.data.books.PageElement;
import com.paleimitations.schoolsofmagic.common.data.books.ParagraphBox;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

public class PageElementParagraphs
extends PageElement {
    public final String textLocation;
    public final int fontColor;
    public final float scale;
    public final List<ParagraphBox> boxes;
    public List<String> text = Lists.newArrayList();
    public boolean tryLoad = true;

    public PageElementParagraphs(String textLocation, float scale, int fontColor, int target, ParagraphBox ... boxes) {
        super(0, 0, target);
        this.textLocation = textLocation;
        this.scale = scale;
        this.fontColor = fontColor;
        this.boxes = Lists.newArrayList((Object[])boxes);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void loadText() {
        this.text.clear();
        Minecraft mc = Minecraft.func_71410_x();
        ResourceLocation fileLoc = new ResourceLocation("schoolsofmagic:lang/book/" + mc.field_71474_y.field_74363_ab + "_0/" + this.textLocation + ".txt");
        ResourceLocation backupLoc = new ResourceLocation("schoolsofmagic:lang/book/en_us_0/" + this.textLocation + ".txt");
        BookTextManager bookTextManager = BookTextManager.INSTANCE;
        IResource resource = bookTextManager.loadTextFile(fileLoc, backupLoc);
        if (resource != null) {
            try {
                String line = "";
                for (String lineAddition : IOUtils.readLines((InputStream)resource.func_199027_b(), (Charset)StandardCharsets.UTF_8)) {
                    line = line + lineAddition;
                }
                Object[] strings = line.split("<~>");
                this.text = Lists.newArrayList((Object[])strings);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("loaded " + fileLoc.toString());
    }

    @Override
    public boolean isTarget(int i) {
        return i <= this.subpage;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasSubpage(int subpage) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        int boxId = 0;
        int linenumber = 0;
        for (String s : this.text) {
            boolean flag = true;
            while (flag) {
                String remainder = null;
                if (this.boxes.size() > boxId && this.boxes.get(boxId) != null) {
                    ParagraphBox box = this.boxes.get(boxId);
                    for (String s1 : PageElementParagraphs.listFormattedStringToWidth(s, Math.round((float)box.width / this.scale))) {
                        font.getClass();
                        if ((linenumber + 1) * 9 <= Math.round((float)box.height / this.scale)) {
                            if (subpage == box.target) {
                                return true;
                            }
                        } else {
                            remainder = remainder == null ? s1 : remainder + s1;
                        }
                        ++linenumber;
                    }
                } else {
                    flag = false;
                }
                if (remainder == null) {
                    flag = false;
                    continue;
                }
                ++boxId;
                linenumber = 0;
                s = remainder;
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawElement(MatrixStack matrixStack, float mouseX, float mouseY, int xIn, int yIn, float zLevel, boolean isGUI, int subpage, int light) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        if (this.tryLoad && this.text.isEmpty()) {
            this.tryLoad = false;
            this.loadText();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
        int boxId = 0;
        int linenumber = 0;
        for (String s : this.text) {
            boolean flag = true;
            while (flag) {
                String remainder = null;
                if (this.boxes.size() > boxId && this.boxes.get(boxId) != null) {
                    ParagraphBox box = this.boxes.get(boxId);
                    int xI = Math.round((float)(box.x + xIn) / this.scale);
                    int yI = Math.round((float)(box.y + yIn) / this.scale);
                    for (String s1 : PageElementParagraphs.listFormattedStringToWidth(s, Math.round((float)box.width / this.scale))) {
                        font.getClass();
                        if ((linenumber + 1) * 9 <= Math.round((float)box.height / this.scale)) {
                            if (subpage == box.target) {
                                float f = xI;
                                font.getClass();
                                font.func_238421_b_(matrixStack, s1, f, (float)(yI + Math.round(linenumber * 9)), 0);
                            }
                        } else {
                            remainder = remainder == null ? s1 : remainder + s1;
                        }
                        ++linenumber;
                    }
                } else {
                    flag = false;
                }
                if (remainder == null) {
                    flag = false;
                    continue;
                }
                ++boxId;
                linenumber = 0;
                s = remainder;
            }
        }
        matrixStack.func_227865_b_();
    }

    public static List<String> listFormattedStringToWidth(String str, int wrapWidth) {
        return Arrays.asList(PageElementParagraphs.wrapFormattedStringToWidth(str, wrapWidth).split("\n"));
    }

    private static String wrapFormattedStringToWidth(String str, int wrapWidth) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        int i = PageElementParagraphs.sizeStringToWidth(str, wrapWidth);
        if (str.length() <= i) {
            return str;
        }
        String s = str.substring(0, i);
        String s1 = str.substring(i);
        return s + "\n" + PageElementParagraphs.wrapFormattedStringToWidth(s1, wrapWidth);
    }

    private static int sizeStringToWidth(String str, int wrapWidth) {
        int k;
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        int i = str.length();
        int j = 0;
        int l = -1;
        boolean flag = false;
        for (k = 0; k < i; ++k) {
            char c0 = str.charAt(k);
            switch (c0) {
                case '\n': {
                    --k;
                    break;
                }
                case ' ': {
                    l = k;
                }
                default: {
                    j += font.func_78256_a(String.valueOf(c0));
                    if (!flag) break;
                    ++j;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (k >= i - 1) break;
                    if ((c1 = str.charAt(++k)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !PageElementParagraphs.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            if (c0 == '\n') {
                l = ++k;
                break;
            }
            if (j > wrapWidth) break;
        }
        return k != i && l != -1 && l < k ? l : k;
    }

    private static boolean isFormatColor(char colorChar) {
        return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
    }
}

