/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.books;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.MagicSchool;
import com.paleimitations.schoolsofmagic.common.data.books.BookPageSpell;
import com.paleimitations.schoolsofmagic.common.data.books.PageElement;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PageElementSpellInfo
extends PageElement {
    public final Spell spell;
    public static final ResourceLocation SPELL_ICONS = new ResourceLocation("schoolsofmagic", "textures/gui/books/magic_icons.png");
    public static final ResourceLocation SPELL_ICONS2 = new ResourceLocation("schoolsofmagic", "textures/gui/spell_charge_icons.png");

    public PageElementSpellInfo(Spell spell) {
        super(0, 0);
        this.spell = spell;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawElement(MatrixStack matrixStack, float mouseX, float mouseY, int xIn, int yIn, float zLevel, boolean isGUI, int target, int light) {
        int i;
        Color color = new Color(BookPageSpell.getColorFromElementList(this.spell.getElements()));
        matrixStack.func_227860_a_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.spell.getSpellIcon());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227860_a_();
        float sSpell = 0.8125f;
        matrixStack.func_227862_a_(sSpell, sSpell, sSpell);
        PageElementSpellInfo.blit(matrixStack, Math.round((float)(24 + xIn) / sSpell), Math.round((float)(50 + yIn) / sSpell), zLevel + (isGUI ? 1.0f : -1.0f), 0.0f, 0.0f, 32, 32, 32, 32, light);
        matrixStack.func_227865_b_();
        PageElementSpellInfo.drawStandardText(matrixStack, I18n.func_135052_a((String)("spell." + this.spell.getName() + ".name"), (Object[])new Object[0]), 68, 18, 85 + xIn, 64.0f + (float)yIn, 0, true, false, isGUI, light);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SPELL_ICONS);
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        PageElementSpellInfo.drawTexturedModalRect(matrixStack, 96 + xIn, 75 + yIn, 96, 120, 21, 110, zLevel, light);
        int boxWidth = 95;
        int boxHeight = 22;
        int boxX = 24;
        int boxY = 77;
        int minSpell = this.spell.minSpellChargeLevel;
        int maxSpell = 8;
        int totalWidth = (maxSpell + 1 - minSpell) * 33;
        float scaleHeight = (float)boxHeight / 32.0f;
        float scaleWidth = (float)boxWidth / (float)totalWidth;
        float scaleSpellSlots = Math.min(scaleHeight, scaleWidth);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scaleSpellSlots, scaleSpellSlots, scaleSpellSlots);
        float startX = (float)xIn + (float)boxX + (float)boxWidth / 2.0f - (float)totalWidth * scaleSpellSlots / 2.0f;
        float startY = (float)yIn + (float)boxY + (float)boxHeight / 2.0f - 16.0f * scaleSpellSlots;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SPELL_ICONS2);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i <= maxSpell - minSpell; ++i) {
            int icon = minSpell + i;
            PageElementSpellInfo.drawTexturedModalRect(matrixStack, Math.round((startX + (float)i * 33.0f * scaleSpellSlots) / scaleSpellSlots), Math.round(startY / scaleSpellSlots), icon % 3 * 32, icon / 3 * 32, 32, 32, zLevel, light);
        }
        matrixStack.func_227865_b_();
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        i = this.drawMaterialComponentTab(matrixStack, 24 + xIn, 100 + yIn, zLevel, isGUI, light);
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        i = this.drawSchoolComponent(matrixStack, 24 + xIn, i, zLevel, isGUI, light);
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        i = this.drawElementComponent(matrixStack, 24 + xIn, i, zLevel, isGUI, light);
        matrixStack.func_227865_b_();
    }

    public static void drawStandardText(MatrixStack matrixStack, String s, int width, int height, float x, float y, int color, boolean centered, boolean dropShadow, boolean gui, int light) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        int textWidth = mc.field_71466_p.func_78256_a(s);
        mc.field_71466_p.getClass();
        int textHeight = 9;
        float scalerWidth = (float)width / Float.valueOf(textWidth).floatValue();
        float scalerHeight = (float)height / Float.valueOf(textHeight).floatValue();
        float scaler = Math.min(scalerWidth, scalerHeight);
        float drawX = x;
        float drawY = y;
        if (centered) {
            drawX = x - (float)textWidth * scaler / 2.0f;
            drawY = y - (float)textHeight * scaler / 2.0f;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scaler, scaler, scaler);
        matrixStack.func_227861_a_(0.0, 0.0, gui ? (double)0.1f : (double)-0.1f);
        if (dropShadow) {
            PageElementSpellInfo.drawString(font, s, drawX / scaler + 0.5f, drawY / scaler + 0.5f, 0, matrixStack, light);
            matrixStack.func_227861_a_(0.0, 0.0, gui ? (double)0.1f : (double)-0.1f);
        }
        PageElementSpellInfo.drawString(font, s, drawX / scaler, drawY / scaler, color, matrixStack, light);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227865_b_();
    }

    public int drawMaterialComponentTab(MatrixStack matrixStack, int x, int y, float zLevel, boolean gui, int light) {
        if (!this.spell.getMaterialComponents().isEmpty()) {
            matrixStack.func_227860_a_();
            Minecraft mc = Minecraft.func_71410_x();
            int j = mc.field_71439_g.field_70173_aa / 60 % this.spell.getMaterialComponents().size();
            ItemStack stack = this.spell.getMaterialComponents().get(j);
            mc.func_110434_K().func_110577_a(SPELL_ICONS);
            PageElementSpellInfo.drawTexturedModalRect(matrixStack, x, y, 0, 165, 73, 18, zLevel, light);
            this.drawItemStack(matrixStack, stack, x + 1, y + 1, gui);
            PageElementSpellInfo.drawStandardText(matrixStack, stack.func_151000_E().func_150261_e(), 51, 8, (float)x + 45.5f, (float)y + 10.0f, 0, true, false, gui, light);
            matrixStack.func_227865_b_();
            return y + 18;
        }
        return y;
    }

    public int drawSchoolComponent(MatrixStack matrixStack, int x, int y, float zLevel, boolean gui, int light) {
        if (!this.spell.getSchools().isEmpty()) {
            boolean flag;
            matrixStack.func_227860_a_();
            Minecraft mc = Minecraft.func_71410_x();
            int j = mc.field_71439_g.field_70173_aa / 60 % this.spell.getSchools().size();
            MagicSchool school = this.spell.getSchools().get(j);
            mc.func_110434_K().func_110577_a(SPELL_ICONS);
            PageElementSpellInfo.drawTexturedModalRect(matrixStack, x, y, 0, 120, 73, 18, zLevel, light);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)x + 2.0f), (double)((float)y + 2.0f), (double)(zLevel + (gui ? 1.0f : -1.0f)));
            matrixStack.func_227862_a_(0.46666667f, 0.46666667f, 1.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            PageElementSpellInfo.drawTexturedModalRect(matrixStack, 0, 0, school.getId() * 30, 60, 30, 30, zLevel, light);
            matrixStack.func_227865_b_();
            boolean bl = flag = this.spell.getMinimumSchoolLevels()[school.getId()] > 0;
            if (flag) {
                PageElementSpellInfo.drawStandardText(matrixStack, I18n.func_135052_a((String)("school." + school.getName() + ".name"), (Object[])new Object[0]), 53, 6, x + 18, y + 2, 0, false, false, gui, light);
                PageElementSpellInfo.drawStandardText(matrixStack, I18n.func_135052_a((String)"page.level.element", (Object[])new Object[0]) + ": " + (this.spell.getMinimumSchoolLevels()[school.getId()] + 1), 53, 6, x + 18, y + 9, 0, false, false, gui, light);
            } else {
                PageElementSpellInfo.drawStandardText(matrixStack, I18n.func_135052_a((String)("school." + school.getName() + ".name"), (Object[])new Object[0]), 53, 8, x + 44, y + 10, 0, true, false, gui, light);
            }
            matrixStack.func_227865_b_();
            return y + 18;
        }
        return y;
    }

    public int drawElementComponent(MatrixStack matrixStack, int x, int y, float zLevel, boolean gui, int light) {
        if (!this.spell.getElements().isEmpty()) {
            boolean flag;
            matrixStack.func_227860_a_();
            Minecraft mc = Minecraft.func_71410_x();
            int j = mc.field_71439_g.field_70173_aa / 60 % this.spell.getElements().size();
            MagicElement element = this.spell.getElements().get(j);
            mc.func_110434_K().func_110577_a(SPELL_ICONS);
            PageElementSpellInfo.drawTexturedModalRect(matrixStack, x, y, 0, 120, 73, 18, zLevel, light);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)x + 2.0f), (double)((float)y + 2.0f), (double)(zLevel + (gui ? 1.0f : -1.0f)));
            matrixStack.func_227862_a_(0.46666667f, 0.46666667f, 1.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            PageElementSpellInfo.drawTexturedModalRect(matrixStack, 0, 0, element.getId() % 8 * 30, element.getId() / 8 * 30, 30, 30, zLevel, light);
            matrixStack.func_227865_b_();
            boolean bl = flag = this.spell.getMinimumElementLevels()[element.getId()] > 0;
            if (flag) {
                PageElementSpellInfo.drawStandardText(matrixStack, I18n.func_135052_a((String)("element." + element.getName() + ".name"), (Object[])new Object[0]), 53, 6, x + 18, y + 2, 0, false, false, gui, light);
                PageElementSpellInfo.drawStandardText(matrixStack, I18n.func_135052_a((String)"page.level.element", (Object[])new Object[0]) + ": " + (this.spell.getMinimumElementLevels()[element.getId()] + 1), 53, 6, x + 18, y + 9, 0, false, false, gui, light);
            } else {
                PageElementSpellInfo.drawStandardText(matrixStack, I18n.func_135052_a((String)("element." + element.getName() + ".name"), (Object[])new Object[0]), 53, 8, x + 44, y + 10, 0, true, false, gui, light);
            }
            matrixStack.func_227865_b_();
            return y + 18;
        }
        return y;
    }

    public int drawModifierComponent(MatrixStack matrixStack, int x, int y, float zLevel, boolean gui, int offset) {
        return y;
    }
}

