/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.capabilities.book_data;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.data.BindingType;
import com.paleimitations.schoolsofmagic.common.data.books.BookPage;
import com.paleimitations.schoolsofmagic.common.data.books.BookPageChapter;
import com.paleimitations.schoolsofmagic.common.data.books.BookPageSpell;
import com.paleimitations.schoolsofmagic.common.data.books.BookPageTableContent;
import com.paleimitations.schoolsofmagic.common.data.books.IBookPageHolder;
import com.paleimitations.schoolsofmagic.common.registries.BookPageRegistry;
import com.paleimitations.schoolsofmagic.common.registries.MagicElementRegistry;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.SpellHelper;
import java.util.List;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.IExtensibleEnum;

public class BookData
extends WorldSavedData
implements IBookPageHolder {
    private List<BookPage> pages = Lists.newArrayList();
    private List<BookPageChapter> chapters = Lists.newArrayList();
    public static DecorationType[] FACETS = new DecorationType[BindingType.values().length];
    public static DecorationType[] JEWELS = new DecorationType[BindingType.values().length];
    public static DecorationType[] FRAMES = new DecorationType[BindingType.values().length];
    public static DecorationType[] SWIRLS = new DecorationType[DyeColor.values().length];
    public static DecorationType[] MAGICS = new DecorationType[BindingType.values().length * MagicElementRegistry.ELEMENTS.size()];

    public BookData(String id) {
        super(id);
    }

    public List<BookPageChapter> getChapters() {
        return this.chapters;
    }

    public Tuple<Integer, Integer> getSurroundingChapters(int page) {
        int back = page;
        for (int i = page - 1; i >= 0; --i) {
            BookPage bookPage = this.getBookPage(i);
            if (bookPage == null || !(bookPage instanceof BookPageChapter)) continue;
            back = i;
            break;
        }
        int forward = page;
        for (int i = page + 1; i < this.pages.size(); ++i) {
            BookPage bookPage = this.getBookPage(i);
            if (bookPage == null || !(bookPage instanceof BookPageChapter)) continue;
            forward = i;
            break;
        }
        return new Tuple((Object)back, (Object)forward);
    }

    public BookPage getBookPage(int page) {
        if (page >= this.pages.size()) {
            return null;
        }
        if (page < 0) {
            return null;
        }
        return this.pages.get(page);
    }

    public int getNumPages() {
        return this.pages.size();
    }

    public List<BookPage> getBookPages() {
        return this.pages;
    }

    public void setBookPages(List<BookPage> pages) {
        this.pages = pages;
        this.update();
        this.func_76185_a();
    }

    public void addBookPages(List<BookPage> pages) {
        this.pages.addAll(pages);
        this.update();
        this.func_76185_a();
    }

    public void addBookPage(BookPage page) {
        this.pages.add(page);
        this.update();
        this.func_76185_a();
    }

    public void removeBookPage(BookPage page) {
        this.pages.removeIf(bookPage -> bookPage == page);
        this.update();
        this.func_76185_a();
    }

    public void removeBookPage(int i) {
        if (this.pages.size() > i) {
            this.pages.removeIf(bookPage -> bookPage == this.pages.get(i));
            this.update();
            this.func_76185_a();
        }
    }

    public void update() {
        this.chapters.clear();
        for (BookPage page : this.pages) {
            if (!(page instanceof BookPageChapter)) continue;
            ((BookPageChapter)page).pageHolder = this;
            ((BookPageChapter)page).buildChapter();
            this.chapters.add((BookPageChapter)page);
        }
        if (this.pages != null && !this.pages.isEmpty() && this.pages.get(0) != null && this.pages.get(0) instanceof BookPageTableContent) {
            ((BookPageTableContent)this.pages.get((int)0)).pageHolder = this;
            ((BookPageTableContent)this.pages.get(0)).buildTableContent();
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        nbt.func_74768_a("pages_size", this.pages.size());
        for (int i = 0; i < this.pages.size(); ++i) {
            if (this.pages.get(i) == null) continue;
            if (this.pages.get(i) instanceof BookPageSpell) {
                nbt.func_74757_a("is_spell_page_" + i, true);
                nbt.func_74778_a("spell_location_" + i, ((BookPageSpell)this.pages.get(i)).getSpell().getResourceLocation().toString());
                nbt.func_218657_a("spell_data_" + i, (INBT)((BookPageSpell)this.pages.get(i)).getSpell().serializeNBT());
                continue;
            }
            nbt.func_74778_a("page_" + i, this.pages.get(i).getName());
        }
        return nbt;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.pages.clear();
        for (int i = 0; i < nbt.func_74762_e("pages_size"); ++i) {
            if (nbt.func_74764_b("is_spell_page_" + i)) {
                Spell spell = SpellHelper.getSpellInstance(new ResourceLocation(nbt.func_74779_i("spell_location_" + i)), nbt.func_74775_l("spell_data_" + i));
                if (spell == null) continue;
                this.pages.add(new BookPageSpell(spell));
                continue;
            }
            BookPage p = BookPageRegistry.getBookPage(nbt.func_74779_i("page_" + i));
            if (p == null) continue;
            this.pages.add(p);
        }
        this.update();
    }

    public static DecorationType getMagicDecoration(BindingType binding, MagicElement element) {
        return MAGICS[binding.ordinal() * MagicElementRegistry.ELEMENTS.size() + element.getId()];
    }

    static {
        for (BindingType bindingType : BindingType.values()) {
            BookData.FACETS[bindingType.ordinal()] = DecorationType.create(bindingType.name() + "_FACET");
            BookData.JEWELS[bindingType.ordinal()] = DecorationType.create(bindingType.name() + "_JEWEL");
            BookData.FRAMES[bindingType.ordinal()] = DecorationType.create(bindingType.name() + "_FRAME");
            for (MagicElement element : MagicElementRegistry.ELEMENTS) {
                BookData.MAGICS[bindingType.ordinal() * MagicElementRegistry.ELEMENTS.size() + element.getId()] = DecorationType.create(bindingType.name() + "_" + element.getName().toUpperCase());
            }
        }
        for (BindingType bindingType : DyeColor.values()) {
            BookData.SWIRLS[bindingType.ordinal()] = DecorationType.create(bindingType.name() + "_SWIRL");
        }
    }

    public static enum DecorationType implements IStringSerializable,
    IExtensibleEnum
    {
        NONE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public static DecorationType create(String enumName) {
            throw new IllegalStateException("Enum not extended");
        }

        public static DecorationType fromName(String name) {
            for (DecorationType type : DecorationType.values()) {
                if (!type.func_176610_l().equalsIgnoreCase(name)) continue;
                return type;
            }
            return NONE;
        }

        public static DecorationType fromIndex(int i) {
            for (DecorationType type : DecorationType.values()) {
                if (type.ordinal() != i) continue;
                return type;
            }
            return NONE;
        }
    }
}

