/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.capabilities.book_data;

import com.google.common.collect.Maps;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookHandlerData;
import com.paleimitations.schoolsofmagic.common.network.GetBookDataPacket;
import com.paleimitations.schoolsofmagic.common.network.PacketHandler;
import com.paleimitations.schoolsofmagic.common.registries.BookPageRegistry;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class BookDataProvider {
    private static final Map<String, BookData> CLIENT_BOOK_DATA = Maps.newHashMap();

    public static void addBookData(String id, BookData data) {
        CLIENT_BOOK_DATA.put(id, data);
    }

    public static int getNextAvailableBookId(World world) {
        return ((BookHandlerData)world.func_73046_m().func_241755_D_().func_217481_x().func_215752_a(() -> new BookHandlerData("book_handler"), "book_handler")).getNewBookId();
    }

    public static BookData getBook(World world, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("book_data_s")) {
                return BookDataProvider.getBook(world, nbt.func_74779_i("book_data_s"));
            }
            if (nbt.func_74764_b("book_data_i")) {
                return BookDataProvider.getBook(world, nbt.func_74762_e("book_data_i"));
            }
        }
        return null;
    }

    public static BookData getBook(World world, int id) {
        String s = "schoolsofmagic_book_" + id;
        if (world.field_72995_K) {
            if (CLIENT_BOOK_DATA.containsKey(s)) {
                return CLIENT_BOOK_DATA.get(s);
            }
            PacketHandler.INSTANCE.sendToServer(new GetBookDataPacket(Minecraft.func_71410_x().field_71439_g.func_145782_y(), s));
            return null;
        }
        return (BookData)world.func_73046_m().func_241755_D_().func_217481_x().func_215752_a(() -> new BookData(s), s);
    }

    public static BookData getBook(World world, String id) {
        if (world.field_72995_K) {
            if (CLIENT_BOOK_DATA.containsKey(id)) {
                return CLIENT_BOOK_DATA.get(id);
            }
            PacketHandler.INSTANCE.sendToServer(new GetBookDataPacket(Minecraft.func_71410_x().field_71439_g.func_145782_y(), id));
            return null;
        }
        return (BookData)world.func_73046_m().func_241755_D_().func_217481_x().func_215752_a(() -> new BookData(id), id);
    }

    @Mod.EventBusSubscriber(modid="schoolsofmagic", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void loadWorld(WorldEvent.Load event) {
            BookData data;
            World world;
            if (event.getWorld() instanceof World && !(world = (World)event.getWorld()).func_201670_d() && (data = BookDataProvider.getBook(world, "schoolsofmagic_book_basic_arcana")).getBookPages() != BookPageRegistry.BASIC_ARCANA) {
                data.getBookPages().clear();
                data.addBookPages(BookPageRegistry.BASIC_ARCANA);
            }
        }
    }
}

