/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.MagicSchool;
import com.paleimitations.schoolsofmagic.common.config.Config;
import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.IMagicData;
import com.paleimitations.schoolsofmagic.common.registries.MagicElementRegistry;
import com.paleimitations.schoolsofmagic.common.registries.MagicSchoolRegistry;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.SpellHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.util.INBTSerializable;

public class MagicData
implements IMagicData,
INBTSerializable<CompoundNBT> {
    public static final int MAX_CHARGE_LEVEL = 9;
    public static final int MAX_MAGICIAN_LEVEL = (Integer)Config.Common.MAX_LEVEL.get();
    public static final int MAX_SPELLS = (Integer)Config.Common.MAX_SPELL_STORAGE.get();
    public static final int[] MAX_COUNTDOWNS = new int[]{(Integer)Config.Common.SPELL_CHARGE_1_RELOAD.get(), (Integer)Config.Common.SPELL_CHARGE_2_RELOAD.get(), (Integer)Config.Common.SPELL_CHARGE_3_RELOAD.get(), (Integer)Config.Common.SPELL_CHARGE_4_RELOAD.get(), (Integer)Config.Common.SPELL_CHARGE_5_RELOAD.get(), (Integer)Config.Common.SPELL_CHARGE_6_RELOAD.get(), (Integer)Config.Common.SPELL_CHARGE_7_RELOAD.get(), (Integer)Config.Common.SPELL_CHARGE_8_RELOAD.get(), (Integer)Config.Common.SPELL_CHARGE_9_RELOAD.get()};
    private Spell[] spells = new Spell[MAX_SPELLS];
    private int spellSlot;
    private int[] charges = new int[9];
    private float magicianXP = 0.0f;
    private float[] elementXP;
    private float[] schoolXP;
    private float spellXP = 0.0f;
    private float potionXP = 0.0f;
    private float ritualXP = 0.0f;
    private int[] countdowns = new int[9];

    public MagicData() {
        this.elementXP = new float[MagicElementRegistry.ELEMENTS.size()];
        this.schoolXP = new float[MagicSchoolRegistry.SCHOOLS.size()];
    }

    @Override
    public void useCharge(int chargeLevel, List<MagicElement> elements, List<MagicSchool> schools, @Nullable IMagicData.EnumMagicTool tool) {
        int n = chargeLevel;
        this.charges[n] = this.charges[n] - 1;
        if (this.countdowns[chargeLevel] == 0) {
            this.resetCountdown(chargeLevel);
        }
        this.addMagicianXP((chargeLevel + 1) * 10);
        for (MagicElement element : elements) {
            this.addElementXP(element, (float)((chargeLevel + 1) * 10) * 1.3333334f * (1.0f / (float)elements.size()));
        }
        for (MagicSchool school : schools) {
            this.addSchoolXP(school, (float)((chargeLevel + 1) * 10) * 1.2f * (1.0f / (float)elements.size()));
        }
        if (tool != null) {
            switch (tool) {
                case SPELL: {
                    this.addSpellXP((float)((chargeLevel + 1) * 10) * 0.6666667f);
                    break;
                }
                case RITUAL: {
                    this.addRitualXP((chargeLevel + 1) * 10);
                    break;
                }
                case POTION: {
                    this.addPotionXP((float)((chargeLevel + 1) * 10) * 3.3333333f);
                }
            }
        }
    }

    @Override
    public int[] getCountdowns() {
        return this.countdowns;
    }

    private void resetCountdown(int chargeLevel) {
        this.countdowns[chargeLevel] = MAX_COUNTDOWNS[chargeLevel];
    }

    @Override
    public List<Spell> getSpells() {
        return Lists.newArrayList((Object[])this.spells);
    }

    @Override
    public int getCurrentSpellSlot() {
        return this.spellSlot;
    }

    @Override
    public void setCurrentSpellSlot(int spellSlot) {
        this.spellSlot = spellSlot;
    }

    @Override
    public Spell getCurrentSpell() {
        if (this.spellSlot < 0) {
            this.spellSlot = 0;
        }
        if (this.spellSlot >= this.spells.length) {
            this.spellSlot = this.spells.length - 1;
        }
        return this.spells[this.spellSlot];
    }

    @Override
    public void setCurrentSpell(Spell spell) {
        this.spells[this.spellSlot] = spell;
    }

    @Override
    public Spell getSpell(int index) {
        return this.spells[index];
    }

    @Override
    public void setSpell(int index, Spell spell) {
        this.spells[index] = spell;
    }

    @Override
    public void update(PlayerEntity player) {
        if (this.countdowns.length > 0) {
            for (int i = 0; i < 9; ++i) {
                if (this.countdowns[i] > 0) {
                    int n = i;
                    this.countdowns[n] = this.countdowns[n] - 1;
                    continue;
                }
                if (this.countdowns[i] != 0 || !this.canAddCharge(i)) continue;
                int n = i;
                this.charges[n] = this.charges[n] + 1;
                if (!this.canAddCharge(i)) continue;
                this.resetCountdown(i);
            }
        }
    }

    @Override
    public boolean hasChargeLevel(int chargeLevel) {
        return this.charges[chargeLevel] > 0;
    }

    @Override
    public boolean canAddCharge(int chargeLevel) {
        return this.charges[chargeLevel] < this.getMaxCharges(chargeLevel, this.getLevel());
    }

    @Override
    public int getMaxCharges(int chargeLevel, int level) {
        switch (chargeLevel) {
            case 0: {
                return 2 + Math.min(6, (level + 1) / 5);
            }
            case 1: {
                return Math.min(6, level / 5);
            }
            case 2: {
                return level < 9 ? 0 : Math.min(5, (level - 4) / 5);
            }
            case 3: {
                return level < 13 ? 0 : Math.min(5, (level - 8) / 5);
            }
            case 4: {
                return level < 16 ? 0 : Math.min(5, (level - 10) / 6);
            }
            case 5: {
                return level < 20 ? 0 : Math.min(4, (level - 11) / 8);
            }
            case 6: {
                return level < 25 ? 0 : Math.min(4, (level - 11) / 9);
            }
            case 7: {
                return level < 30 ? 0 : Math.min(3, (level - 24) / 6);
            }
            case 8: {
                return level < 32 ? 0 : (level < 50 ? 1 : 2);
            }
        }
        return 1;
    }

    @Override
    public int[] getCharges() {
        return this.charges;
    }

    @Override
    public int getLargestChargeLevel() {
        int level = this.getLevel();
        for (int i = 0; i < 9; ++i) {
            if (this.getMaxCharges(i, level) != 0) continue;
            return i - 1;
        }
        return 8;
    }

    @Override
    public int getSpellSlots(ItemStack wand) {
        CompoundNBT nbt = wand.func_196082_o();
        if (nbt.func_74764_b("slotLimit")) {
            return nbt.func_74762_e("slotLimit");
        }
        int level = this.getLevel();
        int slots = 3;
        if (level >= 3) {
            ++slots;
        }
        if (level >= 7) {
            ++slots;
        }
        if (level >= 12) {
            ++slots;
        }
        if (level >= 17) {
            ++slots;
        }
        if (level >= 21) {
            ++slots;
        }
        if (level >= 26) {
            ++slots;
        }
        if (level >= 31) {
            slots += level - 14;
        }
        if (level >= 50) {
            ++slots;
        }
        return slots;
    }

    @Override
    public float getMagicianXP() {
        return this.magicianXP;
    }

    @Override
    public void setMagicianXP(float magicianXP) {
        this.magicianXP = magicianXP;
    }

    @Override
    public void addMagicianXP(float magicianXP) {
        if (this.getLevel() < MAX_MAGICIAN_LEVEL) {
            this.magicianXP += magicianXP;
        }
    }

    @Override
    public void removeMagicianXP(float magicianXP) {
        this.magicianXP -= magicianXP;
        if (this.magicianXP < 0.0f) {
            this.magicianXP = 0.0f;
        }
    }

    @Override
    public Tuple<Float, Float> getMagicianXPToNextLevel() {
        int level = 0;
        float magicianXPTemp = this.magicianXP;
        int nextLevel = 50;
        while (magicianXPTemp > 0.0f && magicianXPTemp > (float)(nextLevel = 50 + level * 10)) {
            magicianXPTemp -= (float)nextLevel;
            ++level;
        }
        return new Tuple((Object)Float.valueOf(magicianXPTemp), (Object)Float.valueOf(nextLevel));
    }

    @Override
    public int getLevel() {
        int nextLevel;
        int level = 0;
        float magicianXPTemp = this.magicianXP;
        while (magicianXPTemp > 0.0f && magicianXPTemp > (float)(nextLevel = 50 + level * 10)) {
            magicianXPTemp -= (float)nextLevel;
            ++level;
        }
        return Math.min(level + 1, MAX_MAGICIAN_LEVEL);
    }

    @Override
    public float[] getElementXPs() {
        return this.elementXP;
    }

    @Override
    public void setElementXPs(float[] xps) {
        this.elementXP = xps;
    }

    @Override
    public float getElementXP(MagicElement element) {
        return this.elementXP[element.getId()];
    }

    @Override
    public void setElementXP(MagicElement element, float elementXP) {
        this.elementXP[element.getId()] = elementXP;
    }

    @Override
    public void addElementXP(MagicElement element, float elementXP) {
        this.elementXP[element.getId()] = Math.min(this.elementXP[element.getId()] + elementXP, this.magicianXP);
    }

    @Override
    public void removeElementXP(MagicElement element, float elementXP) {
        this.elementXP[element.getId()] = Math.max(this.elementXP[element.getId()] - elementXP, 0.0f);
    }

    @Override
    public int getElementLevel(MagicElement element) {
        int nextLevel;
        int level = 0;
        float elementXP = this.getElementXP(element);
        while (elementXP > 0.0f && elementXP > (float)(nextLevel = 50 + level * 10)) {
            elementXP -= (float)nextLevel;
            ++level;
        }
        return level + 1;
    }

    @Override
    public Tuple<Float, Float> getElementXPToNextLevel(MagicElement element) {
        int level = 0;
        float elementXP = this.getElementXP(element);
        int nextLevel = 50;
        while (elementXP > 0.0f && elementXP > (float)(nextLevel = 50 + level * 10)) {
            elementXP -= (float)nextLevel;
            ++level;
        }
        return new Tuple((Object)Float.valueOf(elementXP), (Object)Float.valueOf(nextLevel));
    }

    @Override
    public float[] getSchoolXPs() {
        return this.schoolXP;
    }

    @Override
    public void setSchoolXPs(float[] xps) {
        this.schoolXP = xps;
    }

    @Override
    public float getSchoolXP(MagicSchool school) {
        return this.schoolXP[school.getId()];
    }

    @Override
    public void setSchoolXP(MagicSchool school, float schoolXP) {
        this.schoolXP[school.getId()] = schoolXP;
    }

    @Override
    public void addSchoolXP(MagicSchool school, float schoolXP) {
        this.schoolXP[school.getId()] = Math.min(this.schoolXP[school.getId()] + schoolXP, this.magicianXP);
    }

    @Override
    public void removeSchoolXP(MagicSchool school, float schoolXP) {
        this.schoolXP[school.getId()] = Math.max(this.schoolXP[school.getId()] - schoolXP, 0.0f);
    }

    @Override
    public int getSchoolLevel(MagicSchool school) {
        int nextLevel;
        int level = 0;
        float schoolXP = this.getSchoolXP(school);
        while (schoolXP > 0.0f && schoolXP > (float)(nextLevel = 50 + level * 10)) {
            schoolXP -= (float)nextLevel;
            ++level;
        }
        return level + 1;
    }

    @Override
    public Tuple<Float, Float> getSchoolXPToNextLevel(MagicSchool school) {
        int level = 0;
        float schoolXP = this.getSchoolXP(school);
        int nextLevel = 50;
        while (schoolXP > 0.0f && schoolXP > (float)(nextLevel = 50 + level * 10)) {
            schoolXP -= (float)nextLevel;
            ++level;
        }
        return new Tuple((Object)Float.valueOf(schoolXP), (Object)Float.valueOf(nextLevel));
    }

    @Override
    public float getSpellXP() {
        return this.spellXP;
    }

    @Override
    public void setSpellXP(float spellXP) {
        this.spellXP = spellXP;
    }

    @Override
    public void addSpellXP(float spellXP) {
        this.spellXP += spellXP;
        if (this.spellXP > this.magicianXP) {
            this.spellXP = this.magicianXP;
        }
    }

    @Override
    public void removeSpellXP(float spellXP) {
        this.spellXP -= spellXP;
        if (this.spellXP < 0.0f) {
            this.spellXP = 0.0f;
        }
    }

    @Override
    public int getSpellLevel() {
        int nextLevel;
        int level = 0;
        float spellXPTemp = this.spellXP;
        while (spellXPTemp > 0.0f && spellXPTemp > (float)(nextLevel = 50 + level * 10)) {
            spellXPTemp -= (float)nextLevel;
            ++level;
        }
        return level + 1;
    }

    @Override
    public Tuple<Float, Float> getSpellXPToNextLevel() {
        int level = 0;
        float spellXPTemp = this.spellXP;
        int nextLevel = 50;
        while (spellXPTemp > 0.0f && spellXPTemp > (float)(nextLevel = 50 + level * 10)) {
            spellXPTemp -= (float)nextLevel;
            ++level;
        }
        return new Tuple((Object)Float.valueOf(spellXPTemp), (Object)Float.valueOf(nextLevel));
    }

    @Override
    public float getPotionXP() {
        return this.potionXP;
    }

    @Override
    public void setPotionXP(float potionXP) {
        this.potionXP = potionXP;
    }

    @Override
    public void addPotionXP(float potionXP) {
        this.potionXP += potionXP;
        if (this.potionXP > this.magicianXP) {
            this.potionXP = this.magicianXP;
        }
    }

    @Override
    public void removePotionXP(float potionXP) {
        this.potionXP -= potionXP;
        if (this.potionXP < 0.0f) {
            this.potionXP = 0.0f;
        }
    }

    @Override
    public int getPotionLevel() {
        int nextLevel;
        int level = 0;
        float potionXPTemp = this.potionXP;
        while (potionXPTemp > 0.0f && potionXPTemp > (float)(nextLevel = 50 + level * 10)) {
            potionXPTemp -= (float)nextLevel;
            ++level;
        }
        return level + 1;
    }

    @Override
    public Tuple<Float, Float> getPotionXPToNextLevel() {
        int level = 0;
        float potionXPTemp = this.potionXP;
        int nextLevel = 50;
        while (potionXPTemp > 0.0f && potionXPTemp > (float)(nextLevel = 50 + level * 10)) {
            potionXPTemp -= (float)nextLevel;
            ++level;
        }
        return new Tuple((Object)Float.valueOf(potionXPTemp), (Object)Float.valueOf(nextLevel));
    }

    @Override
    public float getRitualXP() {
        return this.ritualXP;
    }

    @Override
    public void setRitualXP(float ritualXP) {
        this.ritualXP = ritualXP;
    }

    @Override
    public void addRitualXP(float ritualXP) {
        this.ritualXP += ritualXP;
        if (this.ritualXP > this.magicianXP) {
            this.ritualXP = this.magicianXP;
        }
    }

    @Override
    public void removeRitualXP(float ritualXP) {
        this.ritualXP -= ritualXP;
        if (this.ritualXP < 0.0f) {
            this.ritualXP = 0.0f;
        }
    }

    @Override
    public int getRitualLevel() {
        int nextLevel;
        int level = 0;
        float ritualXPTemp = this.ritualXP;
        while (ritualXPTemp > 0.0f && ritualXPTemp > (float)(nextLevel = 50 + level * 10)) {
            ritualXPTemp -= (float)nextLevel;
            ++level;
        }
        return level + 1;
    }

    @Override
    public Tuple<Float, Float> getRitualXPToNextLevel() {
        int level = 0;
        float ritualXPTemp = this.ritualXP;
        int nextLevel = 50;
        while (ritualXPTemp > 0.0f && ritualXPTemp > (float)(nextLevel = 50 + level * 10)) {
            ritualXPTemp -= (float)nextLevel;
            ++level;
        }
        return new Tuple((Object)Float.valueOf(ritualXPTemp), (Object)Float.valueOf(nextLevel));
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("spellSlot", this.spellSlot);
        for (int i = 0; i < MAX_SPELLS; ++i) {
            if (this.spells[i] == null) continue;
            nbt.func_74778_a("spell" + i, this.spells[i].getResourceLocation().toString());
            nbt.func_218657_a("spellData" + i, (INBT)this.spells[i].serializeNBT());
        }
        nbt.func_74783_a("charges", this.charges);
        nbt.func_74783_a("countdowns", this.countdowns);
        nbt.func_74776_a("magicianXP", this.magicianXP);
        for (MagicElement element : MagicElementRegistry.ELEMENTS) {
            nbt.func_74776_a(element.getName() + "XP", this.elementXP[element.getId()]);
        }
        for (MagicSchool school : MagicSchoolRegistry.SCHOOLS) {
            nbt.func_74776_a(school.getName() + "XP", this.schoolXP[school.getId()]);
        }
        nbt.func_74776_a("spellXP", this.spellXP);
        nbt.func_74776_a("ritualXP", this.ritualXP);
        nbt.func_74776_a("potionXP", this.potionXP);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.spellSlot = nbt.func_74762_e("spellSlot");
        for (int i = 0; i < MAX_SPELLS; ++i) {
            if (!nbt.func_74764_b("spell" + i) || !nbt.func_74764_b("spellData" + i)) continue;
            this.spells[i] = SpellHelper.getSpellInstance(new ResourceLocation(nbt.func_74779_i("spell" + i)), nbt.func_74775_l("spellData" + i));
        }
        this.charges = nbt.func_74759_k("charges");
        this.countdowns = nbt.func_74759_k("countdowns");
        this.magicianXP = nbt.func_74760_g("magicianXP");
        for (MagicElement element : MagicElementRegistry.ELEMENTS) {
            this.elementXP[element.getId()] = nbt.func_74760_g(element.getName() + "XP");
        }
        for (MagicSchool school : MagicSchoolRegistry.SCHOOLS) {
            this.schoolXP[school.getId()] = nbt.func_74760_g(school.getName() + "XP");
        }
        this.spellXP = nbt.func_74760_g("spellXP");
        this.ritualXP = nbt.func_74760_g("ritualXP");
        this.potionXP = nbt.func_74760_g("potionXP");
    }
}

