/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data.IQuestData;
import com.paleimitations.schoolsofmagic.common.quests.Quest;
import com.paleimitations.schoolsofmagic.common.quests.QuestHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class QuestData
implements IQuestData,
INBTSerializable<CompoundNBT> {
    public List<Quest> quests = Lists.newArrayList();

    @Override
    public List<Quest> getQuests() {
        return this.quests;
    }

    @Override
    public void addQuest(Quest quest) {
        this.quests.add(quest);
    }

    @Override
    public void updateQuests(PlayerEntity player) {
        ArrayList reset = Lists.newArrayList();
        for (Quest quest : this.quests) {
            quest.update(player);
            if (quest.dead) continue;
            reset.add(quest);
        }
        this.quests = reset;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("NumberOfQuests", this.quests.size());
        for (int i = 0; i < this.quests.size(); ++i) {
            nbt.func_74778_a("QuestLocation" + i, this.quests.get(i).getResourceLocation().toString());
            nbt.func_218657_a("QuestData" + i, (INBT)this.quests.get(i).serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.quests.clear();
        for (int i = 0; i < nbt.func_74762_e("NumberOfQuests"); ++i) {
            Quest q;
            if (!nbt.func_74764_b("QuestLocation" + i) || !nbt.func_74764_b("QuestData" + i) || (q = QuestHelper.getQuestInstance(new ResourceLocation(nbt.func_74779_i("QuestLocation" + i)), nbt.func_74775_l("QuestData" + i))) == null) continue;
            this.quests.add(q);
        }
    }

    @Override
    public boolean hasQuest(UUID questGiver) {
        for (Quest quest : this.quests) {
            if (quest.getQuestGiver() == null || !quest.getQuestGiver().equals(questGiver)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Quest getQuestbyQuestGiver(UUID questGiver) {
        for (Quest quest : this.quests) {
            if (quest.getQuestGiver() == null || !quest.getQuestGiver().equals(questGiver)) continue;
            return quest;
        }
        return null;
    }
}

