/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.items;

import com.paleimitations.schoolsofmagic.common.TeaBrewResult;
import com.paleimitations.schoolsofmagic.common.data.TeaUtils;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import com.paleimitations.schoolsofmagic.common.registries.TeaRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TeacupItem
extends Item {
    public final boolean filled;
    public final Item drinkResult;

    public TeacupItem(Item.Properties props, boolean filled, Item drinkResult) {
        super(props);
        this.filled = filled;
        this.drinkResult = drinkResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        if (this.filled) {
            TeaBrewResult brew = TeaUtils.getTea(stack);
            if (brew != null && !brew.isMilk && brew.successful) {
                if (Screen.func_231173_s_()) {
                    TeaUtils.addTooltip(stack, list, 1.0f);
                } else {
                    list.add((ITextComponent)new TranslationTextComponent("schoolsofmagic.hold_shift").func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC));
                }
            }
        } else {
            super.func_77624_a(stack, world, list, tooltipFlag);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.filled ? TeaUtils.getName(stack, "item.schoolsofmagic.filled_teacup.") : super.func_77667_c(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this == ItemRegistry.FILLED_WHITE_TERRACOTTA_TEACUP.get()) {
            if (this.func_194125_a(group)) {
                for (TeaRegistry.Tea tea : TeaRegistry.TEAS) {
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    TeaUtils.setTea(stack, tea, tea, tea, false);
                    items.add((Object)stack);
                }
            }
        } else if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity living) {
        PlayerEntity playerentity;
        PlayerEntity playerEntity = playerentity = living instanceof PlayerEntity ? (PlayerEntity)living : null;
        if (playerentity instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)playerentity, stack);
        }
        if (!world.field_72995_K) {
            TeaBrewResult brew = TeaUtils.getTea(stack);
            Random rand = living.func_70681_au();
            if (brew.successful) {
                if (brew.isMilk) {
                    living.curePotionEffects(new ItemStack((IItemProvider)Items.field_151117_aB));
                } else {
                    EffectInstance effectinstance;
                    if (!brew.tier1Pool.isEmpty()) {
                        effectinstance = brew.tier1Pool.get(rand.nextInt(brew.tier1Pool.size()));
                        if (effectinstance.func_188419_a().func_76403_b()) {
                            effectinstance.func_188419_a().func_180793_a((Entity)playerentity, (Entity)playerentity, living, effectinstance.func_76458_c(), 1.0);
                        } else {
                            living.func_195064_c(new EffectInstance(effectinstance));
                        }
                    }
                    if (!brew.tier2Pool.isEmpty()) {
                        effectinstance = brew.tier2Pool.get(rand.nextInt(brew.tier2Pool.size()));
                        if (effectinstance.func_188419_a().func_76403_b()) {
                            effectinstance.func_188419_a().func_180793_a((Entity)playerentity, (Entity)playerentity, living, effectinstance.func_76458_c(), 1.0);
                        } else {
                            living.func_195064_c(new EffectInstance(effectinstance));
                        }
                    }
                    if (!brew.tier3Pool.isEmpty()) {
                        effectinstance = brew.tier3Pool.get(rand.nextInt(brew.tier3Pool.size()));
                        if (effectinstance.func_188419_a().func_76403_b()) {
                            effectinstance.func_188419_a().func_180793_a((Entity)playerentity, (Entity)playerentity, living, effectinstance.func_76458_c(), 1.0);
                        } else {
                            living.func_195064_c(new EffectInstance(effectinstance));
                        }
                    }
                }
            }
        }
        if (playerentity != null) {
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            if (!playerentity.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        if (playerentity == null || !playerentity.field_71075_bZ.field_75098_d) {
            if (stack.func_190926_b()) {
                return new ItemStack((IItemProvider)this.drinkResult);
            }
            if (playerentity != null) {
                playerentity.field_71071_by.func_70441_a(new ItemStack((IItemProvider)this.drinkResult));
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return this.filled ? 32 : 0;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return this.filled ? UseAction.DRINK : UseAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        return this.filled ? DrinkHelper.func_234707_a_((World)world, (PlayerEntity)player, (Hand)hand) : ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }
}

