/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.items;

import com.paleimitations.schoolsofmagic.common.data.books.BookPage;
import com.paleimitations.schoolsofmagic.common.data.books.BookPageSpell;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookDataProvider;
import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.IMagicData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.MagicDataProvider;
import com.paleimitations.schoolsofmagic.common.network.PacketHandler;
import com.paleimitations.schoolsofmagic.common.network.SetSpellPacket;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.SpellHelper;
import com.paleimitations.schoolsofmagic.common.tileentities.PodiumTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WandBaseItem
extends Item {
    private final int slotLimit;

    public WandBaseItem(Item.Properties properties, int slotLimit) {
        super(properties.func_200917_a(1));
        this.slotLimit = slotLimit;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        Spell spell;
        if (entity.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY, null).isPresent() && (spell = this.getCurrentSpell(entity)) != null) {
            spell.inventoryTick(stack, world, entity, slot, selected);
        }
        super.func_77663_a(stack, world, entity, slot, selected);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity livingEntity, Hand hand) {
        Spell spell = this.getCurrentSpell((Entity)player);
        if (spell != null) {
            return spell.interactLivingEntity(stack, player, livingEntity, hand);
        }
        return super.func_111207_a(stack, player, livingEntity, hand);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            if (this == ItemRegistry.APPRENTICE_WAND_1.get()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                WandBaseItem.addSlotLimit(stack, 1);
                items.add((Object)stack);
            } else if (this == ItemRegistry.APPRENTICE_WAND_2.get()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                WandBaseItem.addSlotLimit(stack, 2);
                items.add((Object)stack);
            } else if (this == ItemRegistry.APPRENTICE_WAND_3.get()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                WandBaseItem.addSlotLimit(stack, 3);
                items.add((Object)stack);
            } else if (this == ItemRegistry.APPRENTICE_WAND_4.get()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                WandBaseItem.addSlotLimit(stack, 4);
                items.add((Object)stack);
            } else {
                items.add((Object)new ItemStack((IItemProvider)this));
            }
        }
    }

    public void func_77622_d(ItemStack stack1, World world, PlayerEntity player) {
        if (stack1.func_77973_b() == ItemRegistry.APPRENTICE_WAND_1.get()) {
            WandBaseItem.addSlotLimit(stack1, 1);
        } else if (stack1.func_77973_b() == ItemRegistry.APPRENTICE_WAND_2.get()) {
            WandBaseItem.addSlotLimit(stack1, 2);
        } else if (stack1.func_77973_b() == ItemRegistry.APPRENTICE_WAND_3.get()) {
            WandBaseItem.addSlotLimit(stack1, 3);
        } else if (stack1.func_77973_b() == ItemRegistry.APPRENTICE_WAND_4.get()) {
            WandBaseItem.addSlotLimit(stack1, 4);
        }
    }

    public static void addSlotLimit(ItemStack stack, int slotLimit) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a("slotLimit", slotLimit);
        stack.func_77982_d(nbt);
    }

    public IMagicData getMagicData(PlayerEntity player) {
        return (IMagicData)player.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY, null).orElseThrow(IllegalStateException::new);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        Spell spell = this.getCurrentSpell((Entity)player);
        ItemStack stack = this.setUseStackSpell((Entity)player, player.func_184586_b(hand));
        if (spell != null) {
            spell.use(world, player, hand, stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public void func_219972_a(World world, LivingEntity living, ItemStack stack, int count) {
        Spell spell = this.getCurrentSpell((Entity)living);
        if (spell != null) {
            spell.onUseTick(world, living, stack, count);
        }
    }

    public boolean func_219970_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("spell_release")) {
            return stack.func_77978_p().func_74767_n("spell_release");
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Spell spell = this.getCurrentSpell((Entity)context.func_195999_j());
        PlayerEntity player = context.func_195999_j();
        TileEntity te = player.field_70170_p.func_175625_s(context.func_195995_a());
        if (te != null && te instanceof PodiumTileEntity) {
            PodiumTileEntity podium = (PodiumTileEntity)te;
            if (podium.hasBook() && player.field_70170_p.field_72995_K) {
                BookData data = BookDataProvider.getBook(player.field_70170_p, podium.getItem());
                IMagicData magic = this.getMagicData(player);
                CompoundNBT nbt = podium.getItem().func_196082_o();
                int page = nbt.func_74764_b("page") ? nbt.func_74762_e("page") : 0;
                BookPage bookPage = data.getBookPage(page);
                if (bookPage instanceof BookPageSpell && ((BookPageSpell)bookPage).spell != null) {
                    Spell spell1 = SpellHelper.getSpellInstance(((BookPageSpell)bookPage).spell.getResourceLocation(), ((BookPageSpell)bookPage).spell.serializeNBT());
                    magic.setCurrentSpell(spell1);
                    PacketHandler.INSTANCE.sendToServer(new SetSpellPacket(spell1.getResourceLocation(), spell1.serializeNBT(), Minecraft.func_71410_x().field_71439_g.func_145782_y(), magic.getCurrentSpellSlot()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (spell != null) {
            return spell.useOn(context);
        }
        return ActionResultType.PASS;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int count) {
        Spell spell = this.getCurrentSpell((Entity)living);
        if (spell != null) {
            spell.releaseUsing(stack, world, living, count);
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        Spell spell;
        if (living.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY, null).isPresent() && (spell = this.getCurrentSpell((Entity)living)) != null) {
            spell.onUsingTick(stack, living, count);
        }
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity living, LivingEntity attacker) {
        Spell spell = this.getCurrentSpell((Entity)living);
        if (spell != null) {
            return spell.hurtEnemy(stack, living, attacker);
        }
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity living) {
        Spell spell = this.getCurrentSpell((Entity)living);
        if (spell != null) {
            return spell.mineBlock(stack, world, state, pos, living);
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        Spell spell = this.getCurrentSpell((Entity)player);
        if (spell != null) {
            return spell.onBlockStartBreak(stack, pos, player);
        }
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Spell spell = this.getCurrentSpell((Entity)entity);
        if (spell != null) {
            return spell.onPlayerSwing(stack, (PlayerEntity)entity);
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("spell_use_length")) {
            return stack.func_77978_p().func_74762_e("spell_use_length");
        }
        return 0;
    }

    public UseAction func_77661_b(ItemStack stack) {
        UseAction action;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("spell_action") && (action = UseAction.values()[stack.func_77978_p().func_74762_e("spell_action")]) != null) {
            return action;
        }
        return UseAction.BOW;
    }

    public ItemStack setUseStackSpell(Entity entity, ItemStack stack) {
        if (entity instanceof PlayerEntity) {
            IMagicData data = (IMagicData)entity.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY, null).orElseThrow(IllegalStateException::new);
            CompoundNBT nbt = stack.func_196082_o();
            if (data.getCurrentSpell() != null) {
                nbt.func_74768_a("spell_action", data.getCurrentSpell().getAction().ordinal());
                nbt.func_74768_a("spell_use_length", data.getCurrentSpell().getUseLength());
                nbt.func_74757_a("spell_release", data.getCurrentSpell().useOnRelease());
                stack.func_77982_d(nbt);
            } else if (nbt.func_74764_b("spell_action")) {
                nbt.func_82580_o("spell_action");
                nbt.func_82580_o("spell_use_length");
                nbt.func_82580_o("spell_release");
                stack.func_77982_d(nbt);
            }
        }
        return stack;
    }

    public Spell getCurrentSpell(Entity entity) {
        IMagicData data;
        if (entity instanceof PlayerEntity && !((PlayerEntity)entity).func_233643_dh_() && (data = (IMagicData)entity.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY, null).orElseThrow(IllegalStateException::new)).getCurrentSpell() != null) {
            return data.getCurrentSpell();
        }
        return null;
    }
}

