/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.network;

import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookDataProvider;
import com.paleimitations.schoolsofmagic.common.network.PacketHandler;
import com.paleimitations.schoolsofmagic.common.network.ReturnBookDataPacket;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class GetBookDataPacket<MSG> {
    private String bookID;
    private int entityID;

    public GetBookDataPacket(int entityID, String bookID) {
        this.entityID = entityID;
        this.bookID = bookID;
    }

    public static GetBookDataPacket decode(PacketBuffer buf) {
        return new GetBookDataPacket(buf.readInt(), buf.func_150789_c(Short.MAX_VALUE));
    }

    public static void encode(GetBookDataPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.entityID);
        buf.func_180714_a(pkt.bookID);
    }

    public static void handle(GetBookDataPacket pkt, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            BookData data = BookDataProvider.getBook(ctx.getSender().field_70170_p, pkt.bookID);
            Entity entity = ctx.getSender().field_70170_p.func_73045_a(pkt.entityID);
            if (entity instanceof ServerPlayerEntity) {
                PacketHandler.sendTo(new ReturnBookDataPacket(pkt.bookID, data.func_189551_b(new CompoundNBT())), (ServerPlayerEntity)entity);
            }
        });
        ctx.setPacketHandled(true);
    }
}

