/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.network;

import com.paleimitations.schoolsofmagic.common.quests.quests.QuestEnchantItem;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.network.NetworkEvent;

public class LetterPacket {
    private int entityID;
    private Hand hand;
    private int eventType;

    public LetterPacket(int entityID, Hand hand, int eventType) {
        this.entityID = entityID;
        this.hand = hand;
        this.eventType = eventType;
    }

    public static LetterPacket decode(PacketBuffer buf) {
        return new LetterPacket(buf.readInt(), Hand.values()[buf.readInt()], buf.readInt());
    }

    public static void encode(LetterPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.entityID);
        buf.writeInt(pkt.hand.ordinal());
        buf.writeInt(pkt.eventType);
    }

    public static void handle(LetterPacket pkt, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            Entity entity = ctx.getSender().field_70170_p.func_73045_a(pkt.entityID);
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                ItemStack stack = player.func_184586_b(pkt.hand);
                CompoundNBT nbt = stack.func_196082_o();
                if (stack.func_77973_b() == ItemRegistry.LETTER_CCW.get()) {
                    if (pkt.eventType < 2) {
                        nbt.func_74757_a("opened", pkt.eventType == 0);
                        if (pkt.eventType == 0) {
                            player.func_184185_a(SoundEvents.field_187665_Y, 0.1f, 1.0f);
                        } else {
                            player.func_184185_a(SoundEvents.field_219617_ah, 0.1f, 1.0f);
                        }
                    }
                    if (pkt.eventType == 0 && !nbt.func_74764_b("quest")) {
                        nbt.func_74757_a("quest", true);
                    }
                    if (pkt.eventType == 2 && nbt.func_74764_b("quest") && nbt.func_74767_n("quest")) {
                        nbt.func_74757_a("quest", false);
                        ItemStack questNote = new ItemStack((IItemProvider)ItemRegistry.QUEST_NOTE.get());
                        CompoundNBT nbtQ = questNote.func_196082_o();
                        nbtQ.func_74778_a("quest", LetterPacket.getRandomQuest(player.func_70681_au()).toString());
                        questNote.func_77982_d(nbtQ);
                        player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), questNote));
                        player.func_184185_a(SoundEvents.field_219617_ah, 0.1f, 1.0f);
                    }
                    stack.func_77982_d(nbt);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    private static ResourceLocation getRandomQuest(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return new ResourceLocation("schoolsofmagic", "brew_potion");
            }
            case 1: {
                return new ResourceLocation("schoolsofmagic", "enchant_item");
            }
            case 2: {
                return new ResourceLocation("schoolsofmagic", "build_golem");
            }
        }
        return new QuestEnchantItem().getResourceLocation();
    }
}

