/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.network;

import com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data.IQuestData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data.QuestDataProvider;
import com.paleimitations.schoolsofmagic.common.quests.Quest;
import com.paleimitations.schoolsofmagic.common.quests.QuestHelper;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class QuestNotePacket {
    private int entityID;
    private Hand hand;
    private int eventType;

    public QuestNotePacket(int entityID, Hand hand, int eventType) {
        this.entityID = entityID;
        this.hand = hand;
        this.eventType = eventType;
    }

    public static QuestNotePacket decode(PacketBuffer buf) {
        return new QuestNotePacket(buf.readInt(), Hand.values()[buf.readInt()], buf.readInt());
    }

    public static void encode(QuestNotePacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.entityID);
        buf.writeInt(pkt.hand.ordinal());
        buf.writeInt(pkt.eventType);
    }

    public static void handle(QuestNotePacket pkt, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            Entity entity = ctx.getSender().field_70170_p.func_73045_a(pkt.entityID);
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                ItemStack stack = player.func_184586_b(pkt.hand);
                CompoundNBT nbt = stack.func_196082_o();
                if (stack.func_77973_b() == ItemRegistry.QUEST_NOTE.get() && nbt.func_186855_b("quest_giver") && nbt.func_74764_b("quest")) {
                    IQuestData data = QuestDataProvider.getData(player);
                    switch (pkt.eventType) {
                        case 0: {
                            System.out.println("Receiving Quest Note Clear");
                            Quest q = data.getQuestbyQuestGiver(nbt.func_186857_a("quest_giver"));
                            if (q != null) {
                                q.dead = true;
                                stack.func_190918_g(1);
                                break;
                            }
                            System.out.println("Error Null Quest");
                            break;
                        }
                        case 1: {
                            System.out.println("Receiving Quest Note Claim");
                            Quest q = data.getQuestbyQuestGiver(nbt.func_186857_a("quest_giver"));
                            if (q != null) {
                                q.claim(player);
                                stack.func_190918_g(1);
                                break;
                            }
                            System.out.println("Error Null Quest");
                            break;
                        }
                        case 2: {
                            Quest q;
                            System.out.println("Receiving Quest Note Start");
                            if (!data.hasQuest(nbt.func_186857_a("quest_giver"))) {
                                q = QuestHelper.getNewInstance(new ResourceLocation(nbt.func_74779_i("quest")));
                                q.setQuestGiver(nbt.func_186857_a("quest_giver"));
                                data.addQuest(q);
                                break;
                            }
                            System.out.println("Error Already Has This Quest");
                        }
                    }
                    if (pkt.eventType > 2) {
                        System.out.println("Receiving Quest Note Task Start");
                        int i = pkt.eventType - 3;
                        Quest q = data.getQuestbyQuestGiver(nbt.func_186857_a("quest_giver"));
                        if (q != null && i < q.tasks.size() && q.tasks.get(i) != null && q.tasks.get(i).canStart(q)) {
                            q.tasks.get(i).setStarted(true);
                        }
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

