/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.network;

import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.IMagicData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.MagicDataProvider;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.SpellHelper;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetSpellPacket<MSG> {
    private ResourceLocation spellLocation;
    private CompoundNBT spellData;
    private int entityID;
    private int spellSlot;

    public SetSpellPacket(ResourceLocation spellLocation, CompoundNBT spellData, int entityID, int spellSlot) {
        this.spellLocation = spellLocation;
        this.spellData = spellData;
        this.entityID = entityID;
        this.spellSlot = spellSlot;
    }

    public static SetSpellPacket decode(PacketBuffer buf) {
        return new SetSpellPacket(new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)), buf.func_150793_b(), buf.readInt(), buf.readInt());
    }

    public static void encode(SetSpellPacket pkt, PacketBuffer buf) {
        buf.func_180714_a(pkt.spellLocation.toString());
        buf.func_150786_a(pkt.spellData);
        buf.writeInt(pkt.entityID);
        buf.writeInt(pkt.spellSlot);
    }

    public static void handle(SetSpellPacket pkt, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            Entity entity = ctx.getSender().field_70170_p.func_73045_a(pkt.entityID);
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                IMagicData data = (IMagicData)player.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY, null).orElseThrow(IllegalStateException::new);
                Spell spell = SpellHelper.getSpellInstance(pkt.spellLocation, pkt.spellData);
                if (spell != null) {
                    data.setSpell(pkt.spellSlot, spell);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

