/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.network;

import com.paleimitations.schoolsofmagic.common.items.BookBaseItem;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class TurnPageEntityPacket<MSG> {
    private int page;
    private int subpage;
    private int entityID;
    private Hand hand;

    public TurnPageEntityPacket(int page, int subpage, int entityID, Hand hand) {
        this.page = page;
        this.subpage = subpage;
        this.entityID = entityID;
        this.hand = hand;
    }

    public static TurnPageEntityPacket decode(PacketBuffer buf) {
        return new TurnPageEntityPacket(buf.readInt(), buf.readInt(), buf.readInt(), Hand.values()[buf.readInt()]);
    }

    public static void encode(TurnPageEntityPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.page);
        buf.writeInt(pkt.subpage);
        buf.writeInt(pkt.entityID);
        buf.writeInt(pkt.hand.ordinal());
    }

    public static void handle(TurnPageEntityPacket pkt, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            PlayerEntity player;
            ItemStack stack;
            Entity entity = ctx.getSender().field_70170_p.func_73045_a(pkt.entityID);
            if (entity instanceof PlayerEntity && (stack = (player = (PlayerEntity)entity).func_184586_b(pkt.hand)).func_77973_b() instanceof BookBaseItem) {
                CompoundNBT nbt = stack.func_196082_o();
                nbt.func_74768_a("page", pkt.page);
                nbt.func_74768_a("subpage", pkt.subpage);
                stack.func_77982_d(nbt);
            }
        });
        ctx.setPacketHandled(true);
    }
}

