/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.network;

import com.paleimitations.schoolsofmagic.common.items.BookBaseItem;
import com.paleimitations.schoolsofmagic.common.tileentities.PodiumTileEntity;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class TurnPageTileEntityPacket<MSG> {
    private int page;
    private int subpage;
    private int entityID;
    private BlockPos pos;

    public TurnPageTileEntityPacket(int page, int subpage, int entityID, BlockPos pos) {
        this.page = page;
        this.subpage = subpage;
        this.entityID = entityID;
        this.pos = pos;
    }

    public static TurnPageTileEntityPacket decode(PacketBuffer buf) {
        return new TurnPageTileEntityPacket(buf.readInt(), buf.readInt(), buf.readInt(), BlockPos.func_218283_e((long)buf.readLong()));
    }

    public static void encode(TurnPageTileEntityPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.page);
        buf.writeInt(pkt.subpage);
        buf.writeInt(pkt.entityID);
        buf.writeLong(pkt.pos.func_218275_a());
    }

    public static void handle(TurnPageTileEntityPacket pkt, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileEntity entity = ctx.getSender().field_70170_p.func_175625_s(pkt.pos);
            if (entity instanceof PodiumTileEntity) {
                PodiumTileEntity podium = (PodiumTileEntity)entity;
                ItemStack stack = podium.getItem();
                if (stack.func_77973_b() instanceof BookBaseItem) {
                    CompoundNBT nbt = stack.func_196082_o();
                    nbt.func_74768_a("page", pkt.page);
                    nbt.func_74768_a("subpage", pkt.subpage);
                    stack.func_77982_d(nbt);
                }
                podium.setItem(stack);
            }
        });
        ctx.setPacketHandled(true);
    }
}

