/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.network;

import com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data.IQuestData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data.QuestDataProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateQuestDataPacket<MSG> {
    private int entityID;
    private CompoundNBT data;

    public UpdateQuestDataPacket(int entityID, CompoundNBT data) {
        this.entityID = entityID;
        this.data = data;
    }

    public static UpdateQuestDataPacket decode(PacketBuffer buf) {
        return new UpdateQuestDataPacket(buf.readInt(), buf.func_150793_b());
    }

    public static void encode(UpdateQuestDataPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.entityID);
        buf.func_150786_a(pkt.data);
    }

    public static void handle(UpdateQuestDataPacket pkt, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(pkt.entityID);
                if (entity instanceof PlayerEntity) {
                    System.out.println("Quest Data recieved for: " + ((PlayerEntity)entity).func_146103_bH().getName());
                    IQuestData data = (IQuestData)entity.getCapability(QuestDataProvider.QUEST_DATA_CAPABILITY, null).orElseThrow(IllegalStateException::new);
                    data.deserializeNBT(pkt.data);
                } else {
                    System.out.println("Broken Packet");
                }
            } else {
                System.out.println("Packet Sent to Wrong Side");
            }
        });
        ctx.setPacketHandled(true);
    }
}

