/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.network;

import com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data.IQuestData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.quest_data.QuestDataProvider;
import com.paleimitations.schoolsofmagic.common.quests.Quest;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateQuestPacket<MSG> {
    private int entityID;
    private UUID questGiver;
    private CompoundNBT data;

    public UpdateQuestPacket(int entityID, UUID questGiver, CompoundNBT data) {
        this.entityID = entityID;
        this.questGiver = questGiver;
        this.data = data;
    }

    public static UpdateQuestPacket decode(PacketBuffer buf) {
        return new UpdateQuestPacket(buf.readInt(), buf.func_179253_g(), buf.func_150793_b());
    }

    public static void encode(UpdateQuestPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.entityID);
        buf.func_179252_a(pkt.questGiver);
        buf.func_150786_a(pkt.data);
    }

    public static void handle(UpdateQuestPacket pkt, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(pkt.entityID);
                if (entity instanceof PlayerEntity) {
                    System.out.println("Quest recieved for: " + ((PlayerEntity)entity).func_146103_bH().getName());
                    IQuestData data = (IQuestData)entity.getCapability(QuestDataProvider.QUEST_DATA_CAPABILITY, null).orElseThrow(IllegalStateException::new);
                    Quest quest = data.getQuestbyQuestGiver(pkt.questGiver);
                    if (quest != null) {
                        quest.deserializeNBT(pkt.data);
                    } else {
                        System.out.println("ERROR: Missing Quest");
                    }
                } else {
                    System.out.println("ERROR: Broken Packet");
                }
            } else {
                System.out.println("ERROR: Packet Sent to Wrong Side");
            }
        });
        ctx.setPacketHandled(true);
    }
}

