/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.quests;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.network.PacketHandler;
import com.paleimitations.schoolsofmagic.common.network.UpdateQuestPacket;
import com.paleimitations.schoolsofmagic.common.quests.Task;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class Quest
implements INBTSerializable<CompoundNBT> {
    private ResourceLocation resourceLocation;
    public List<Task> tasks = Lists.newArrayList();
    public UUID questGiver;
    public boolean completed = false;
    public boolean failed = false;
    public boolean dead = false;
    public boolean isDirty = false;
    public ItemStack icon = null;
    public List<ItemStack> rewards = Lists.newArrayList();

    public Quest(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public Quest(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public UUID getQuestGiver() {
        return this.questGiver;
    }

    public void setQuestGiver(UUID questGiver) {
        this.questGiver = questGiver;
    }

    public void onClaim(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            for (ItemStack stack : this.rewards) {
                player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), stack));
            }
        }
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public boolean canClaim() {
        return this.completed && !this.dead;
    }

    public void claim(PlayerEntity player) {
        if (this.canClaim()) {
            System.out.println("Quest Claim");
            this.onClaim(player);
            for (Task task : this.tasks) {
                if (task.dead) continue;
                task.claim(player);
            }
            this.dead = true;
        }
    }

    public boolean isQuestGiver(Entity entity) {
        return entity.func_110124_au().equals(this.questGiver);
    }

    public void update(PlayerEntity player) {
        if (this.isDirty && player instanceof ServerPlayerEntity) {
            PacketHandler.sendToTracking(new UpdateQuestPacket(player.func_145782_y(), this.getQuestGiver(), this.serializeNBT()), (ServerPlayerEntity)player);
        }
        if (!(this.completed || this.dead || this.failed)) {
            boolean flag = true;
            boolean flag1 = false;
            for (Task task : this.tasks) {
                task.update(player);
                if (!task.completed) {
                    flag = false;
                }
                if (!task.failed) continue;
                flag1 = true;
            }
            this.completed = flag;
            if (this.completed) {
                this.onCompletion(player);
            }
            this.failed = flag1;
            if (this.failed) {
                this.onFailure(player);
            }
        }
    }

    public void onCompletion(PlayerEntity player) {
        System.out.println("Quest Completed");
    }

    public void onFailure(PlayerEntity player) {
    }

    public void initialize() {
    }

    public CompoundNBT serializeNBT() {
        int i;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("resourceLocation", this.resourceLocation.toString());
        for (i = 0; i < this.tasks.size(); ++i) {
            nbt.func_218657_a("Task" + i, (INBT)this.tasks.get(i).serializeNBT());
        }
        nbt.func_74757_a("Completed", this.completed);
        nbt.func_74757_a("Failed", this.failed);
        nbt.func_74757_a("Dead", this.dead);
        if (this.icon != null) {
            nbt.func_218657_a("Icon", (INBT)this.icon.serializeNBT());
        }
        if (this.questGiver != null) {
            nbt.func_186854_a("QuestGiver", this.questGiver);
        }
        nbt.func_74768_a("RewardsSize", this.rewards.size());
        for (i = 0; i < this.rewards.size(); ++i) {
            nbt.func_218657_a("Reward" + i, (INBT)this.rewards.get(i).serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        int i;
        this.initialize();
        this.resourceLocation = new ResourceLocation(nbt.func_74779_i("resourceLocation"));
        for (i = 0; i < this.tasks.size(); ++i) {
            this.tasks.get(i).deserializeNBT(nbt.func_74775_l("Task" + i));
        }
        this.completed = nbt.func_74767_n("Completed");
        this.failed = nbt.func_74767_n("Failed");
        this.dead = nbt.func_74767_n("Dead");
        if (nbt.func_186855_b("QuestGiver")) {
            this.questGiver = nbt.func_186857_a("QuestGiver");
        }
        if (nbt.func_74764_b("Icon")) {
            this.icon = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Icon"));
        }
        this.rewards.clear();
        for (i = 0; i < nbt.func_74762_e("RewardsSize"); ++i) {
            this.rewards.add(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Reward" + i)));
        }
    }
}

