/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.quests;

import com.paleimitations.schoolsofmagic.common.quests.Quest;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.util.INBTSerializable;

public class Task
implements INBTSerializable<CompoundNBT> {
    public final EnumTaskType taskType;
    public boolean started = false;
    public boolean completed = false;
    public boolean failed = false;
    public boolean isTimed = false;
    public boolean dead = false;
    public int countdown = 0;
    public ItemStack icon;
    public String name;
    public Predicate<Quest> prerequisite = null;
    public Tuple<Integer, Integer> progress = null;

    public Task(EnumTaskType taskType) {
        this.taskType = taskType;
    }

    public void onCompletion(PlayerEntity player) {
    }

    public void onClaim(PlayerEntity player) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean check(PlayerEntity player, Object object) {
        return false;
    }

    public boolean tryStart(Quest quest) {
        if (!this.started && quest != null && this.canStart(quest)) {
            this.started = true;
            return true;
        }
        return false;
    }

    public void checkEvent(PlayerEntity player, Object object) {
        if (this.isOngoing() && this.check(player, object)) {
            this.completed = true;
            this.onCompletion(player);
            player.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
            System.out.println("Task Checked");
        }
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public boolean canClaim() {
        return this.completed && !this.dead;
    }

    public void claim(PlayerEntity player) {
        if (this.canClaim()) {
            this.onClaim(player);
            this.dead = true;
        }
    }

    public boolean isOngoing() {
        return this.started && !this.completed && !this.failed;
    }

    public void update(PlayerEntity player) {
        if (this.isTimed && this.started && !this.completed) {
            if (this.countdown > 0) {
                --this.countdown;
            } else {
                this.failed = true;
                this.onFailure(player);
            }
        }
    }

    public void onFailure(PlayerEntity player) {
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean canStart(Quest quest) {
        return !this.started && (this.prerequisite == null || this.prerequisite.test(quest));
    }

    public void setPrerequisite(Predicate<Quest> prerequisite) {
        this.prerequisite = prerequisite;
    }

    public Predicate<Quest> getPrerequisite() {
        return this.prerequisite;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public int getCountdown() {
        return this.countdown;
    }

    public void setCountdown(int countdown) {
        this.countdown = countdown;
    }

    public boolean isTimed() {
        return this.isTimed;
    }

    public void setTimed(boolean timed) {
        this.isTimed = timed;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("Timed", this.isTimed);
        nbt.func_74757_a("Completed", this.completed);
        nbt.func_74757_a("Failed", this.failed);
        nbt.func_74757_a("Started", this.started);
        nbt.func_74768_a("Countdown", this.countdown);
        if (this.name != null) {
            nbt.func_74778_a("Name", this.name);
        }
        if (this.icon != null) {
            nbt.func_218657_a("Icon", (INBT)this.icon.serializeNBT());
        }
        if (this.progress != null) {
            nbt.func_74768_a("ProgressMin", ((Integer)this.progress.func_76341_a()).intValue());
            nbt.func_74768_a("ProgressMax", ((Integer)this.progress.func_76340_b()).intValue());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.isTimed = nbt.func_74767_n("Timed");
        this.completed = nbt.func_74767_n("Completed");
        this.failed = nbt.func_74767_n("Failed");
        this.started = nbt.func_74767_n("Started");
        this.countdown = nbt.func_74762_e("Countdown");
        if (nbt.func_74764_b("Name")) {
            this.name = nbt.func_74779_i("Name");
        }
        if (nbt.func_74764_b("Icon")) {
            this.icon = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Icon"));
        }
        if (nbt.func_74764_b("ProgressMin") && nbt.func_74764_b("ProgressMax")) {
            this.progress = new Tuple((Object)nbt.func_74762_e("ProgressMin"), (Object)nbt.func_74762_e("ProgressMax"));
        }
    }

    public static enum EnumTaskType implements IStringSerializable
    {
        RETRIEVE,
        BATTLE,
        BEFRIEND,
        BUILD,
        BREAK,
        GO,
        POTION_BREW,
        MORTAR,
        BASIN,
        BREED,
        ENCHANT,
        SPELL,
        LIGHT_BRAZIER,
        RITUAL_RECIPE,
        OTHER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

