/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.quests.quests;

import com.paleimitations.schoolsofmagic.common.items.BookBaseItem;
import com.paleimitations.schoolsofmagic.common.quests.Quest;
import com.paleimitations.schoolsofmagic.common.quests.Task;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.event.world.BlockEvent;

public class QuestBuildGolem
extends Quest {
    public QuestBuildGolem() {
        super(new ResourceLocation("schoolsofmagic", "build_golem"));
        this.initialize();
    }

    public QuestBuildGolem(ResourceLocation location) {
        this();
    }

    public QuestBuildGolem(CompoundNBT nbt) {
        super(nbt);
    }

    @Override
    public void initialize() {
        System.out.println("Init Build Golem Quest");
        this.tasks.clear();
        Task task = new Task(Task.EnumTaskType.BUILD){
            private BlockPattern snowmanPattern;
            private BlockPattern golemPattern;
            private BlockPattern witherPattern;
            private final com.google.common.base.Predicate<BlockState> IS_PUMPKIN;
            private final com.google.common.base.Predicate<BlockState> IS_WITHER_SKELETON;
            {
                this.IS_PUMPKIN = p_apply_1_ -> p_apply_1_ != null && (p_apply_1_.func_177230_c() == Blocks.field_196628_cT || p_apply_1_.func_177230_c() == Blocks.field_196625_cS);
                this.IS_WITHER_SKELETON = p_apply_1_ -> p_apply_1_ != null && (p_apply_1_.func_177230_c() == Blocks.field_196705_eO || p_apply_1_.func_177230_c() == Blocks.field_196704_eN);
            }

            @Override
            public boolean check(PlayerEntity player, Object object) {
                if (object instanceof BlockEvent.EntityPlaceEvent) {
                    BlockEvent.EntityPlaceEvent event = (BlockEvent.EntityPlaceEvent)object;
                    if (this.IS_PUMPKIN.test((Object)event.getPlacedBlock())) {
                        return this.getSnowmanPattern().func_177681_a((IWorldReader)event.getWorld(), event.getPos()) != null || this.getGolemPattern().func_177681_a((IWorldReader)event.getWorld(), event.getPos()) != null;
                    }
                    if (this.IS_WITHER_SKELETON.test((Object)event.getPlacedBlock())) {
                        return this.getWitherPattern().func_177681_a((IWorldReader)event.getWorld(), event.getPos()) != null;
                    }
                    return false;
                }
                return false;
            }

            @Override
            public void onCompletion(PlayerEntity player) {
                QuestBuildGolem.this.markDirty();
            }

            protected BlockPattern getSnowmanPattern() {
                if (this.snowmanPattern == null) {
                    this.snowmanPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"^", "#", "#"}).func_177662_a('^', CachedBlockInfo.func_177510_a(this.IS_PUMPKIN)).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_196604_cC))).func_177661_b();
                }
                return this.snowmanPattern;
            }

            protected BlockPattern getGolemPattern() {
                if (this.golemPattern == null) {
                    this.golemPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', CachedBlockInfo.func_177510_a(this.IS_PUMPKIN)).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150339_S))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
                }
                return this.golemPattern;
            }

            private BlockPattern getWitherPattern() {
                if (this.witherPattern == null) {
                    this.witherPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"^^^", "###", "~#~"}).func_177662_a('#', p_235639_0_ -> p_235639_0_.func_177509_a().func_235714_a_((ITag)BlockTags.field_232871_ah_)).func_177662_a('^', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_196705_eO).or((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_196704_eN)))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
                }
                return this.witherPattern;
            }
        };
        task.setStarted(true);
        this.tasks.add(task);
        this.rewards.add(BookBaseItem.initialize(new ItemStack((IItemProvider)ItemRegistry.BASIC_ARCANA.get())));
        ItemStack stack = new ItemStack((IItemProvider)ItemRegistry.QUEST_NOTE.get());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("quest", "schoolsofmagic:intermediate_arcana");
        stack.func_77982_d(nbt);
        this.icon = new ItemStack((IItemProvider)Blocks.field_196625_cS);
    }
}

