/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.quests.quests;

import com.paleimitations.schoolsofmagic.common.items.BookBaseItem;
import com.paleimitations.schoolsofmagic.common.quests.Quest;
import com.paleimitations.schoolsofmagic.common.quests.Task;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import net.minecraft.block.Blocks;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class QuestEnchantItem
extends Quest {
    public QuestEnchantItem() {
        super(new ResourceLocation("schoolsofmagic", "enchant_item"));
        this.initialize();
    }

    public QuestEnchantItem(ResourceLocation location) {
        this();
    }

    public QuestEnchantItem(CompoundNBT nbt) {
        super(nbt);
    }

    @Override
    public void initialize() {
        System.out.println("Init Enchant Item Quest");
        this.tasks.clear();
        Task task = new Task(Task.EnumTaskType.ENCHANT){
            private int score;
            {
                this.score = -1;
            }

            @Override
            public void onCompletion(PlayerEntity player) {
                QuestEnchantItem.this.markDirty();
            }

            @Override
            public boolean check(PlayerEntity player, Object object) {
                int a = -1;
                if (player instanceof ServerPlayerEntity) {
                    a = ((ServerPlayerEntity)player).func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188091_Y));
                } else if (player instanceof ClientPlayerEntity) {
                    a = ((ClientPlayerEntity)player).func_146107_m().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188091_Y));
                }
                boolean flag = this.score > -1 && a > this.score;
                this.score = a;
                return flag;
            }

            @Override
            public void update(PlayerEntity player) {
                if (player.field_70173_aa % 20 == 0) {
                    this.checkEvent(player, null);
                }
                super.update(player);
            }

            @Override
            public CompoundNBT serializeNBT() {
                CompoundNBT nbt = super.serializeNBT();
                nbt.func_74768_a("Score", this.score);
                return nbt;
            }

            @Override
            public void deserializeNBT(CompoundNBT nbt) {
                super.deserializeNBT(nbt);
                this.score = nbt.func_74762_e("Score");
            }
        };
        task.setStarted(true);
        this.tasks.add(task);
        this.rewards.add(BookBaseItem.initialize(new ItemStack((IItemProvider)ItemRegistry.BASIC_ARCANA.get())));
        ItemStack stack = new ItemStack((IItemProvider)ItemRegistry.QUEST_NOTE.get());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("quest", "schoolsofmagic:intermediate_arcana");
        stack.func_77982_d(nbt);
        this.icon = new ItemStack((IItemProvider)Blocks.field_150381_bn);
    }
}

