/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.registries;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.registries.MagicElementRegistry;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.SpellHelper;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasAdjustableElements;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasDuration;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasMultiUses;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasPower;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.Modifier;
import com.paleimitations.schoolsofmagic.common.spells.spells.BlazeSpell;
import com.paleimitations.schoolsofmagic.common.spells.spells.FangMangleSpell;
import com.paleimitations.schoolsofmagic.common.spells.spells.GrowthSpell;
import com.paleimitations.schoolsofmagic.common.spells.spells.HealingSpell;
import com.paleimitations.schoolsofmagic.common.spells.spells.InvisibilitySpell;
import com.paleimitations.schoolsofmagic.common.spells.spells.ShulkerBulletSpell;
import com.paleimitations.schoolsofmagic.common.spells.spells.SnowballSpell;
import com.paleimitations.schoolsofmagic.common.spells.spells.TranslocationSpell;
import com.paleimitations.schoolsofmagic.common.spells.spells.ZephyrSpell;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class SpellRegistry {
    public static final List<Spell> SPELLS = Lists.newArrayList();
    public static final List<Modifier> MODIFIERS = Lists.newArrayList();

    public static void init() {
        SpellHelper.registerSpellHelpers(new BlazeSpell());
        SpellHelper.registerSpellHelpers(new ZephyrSpell());
        SpellHelper.registerSpellHelpers(new GrowthSpell());
        SpellHelper.registerSpellHelpers(new SnowballSpell());
        SpellHelper.registerSpellHelpers(new ShulkerBulletSpell());
        SpellHelper.registerSpellHelpers(new TranslocationSpell());
        SpellHelper.registerSpellHelpers(new FangMangleSpell());
        SpellHelper.registerSpellHelpers(new InvisibilitySpell());
        SpellHelper.registerSpellHelpers(new HealingSpell());
        new Modifier(new ResourceLocation("schoolsofmagic", "potent_1"), spell -> spell instanceof IHasPower, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "potent_2"), spell -> spell instanceof IHasPower, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "potent_3"), spell -> spell instanceof IHasPower, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "potent_4"), spell -> spell instanceof IHasPower, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "diminished_1"), spell -> spell instanceof IHasPower, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "diminished_2"), spell -> spell instanceof IHasPower, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "diminished_3"), spell -> spell instanceof IHasPower, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "diminished_4"), spell -> spell instanceof IHasPower, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "lasting_1"), spell -> spell instanceof IHasDuration, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "lasting_2"), spell -> spell instanceof IHasDuration, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "lasting_3"), spell -> spell instanceof IHasDuration, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "lasting_4"), spell -> spell instanceof IHasDuration, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "fleeting_1"), spell -> spell instanceof IHasDuration, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "fleeting_2"), spell -> spell instanceof IHasDuration, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "fleeting_3"), spell -> spell instanceof IHasDuration, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "fleeting_4"), spell -> spell instanceof IHasDuration, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "economical_1"), spell -> spell instanceof IHasMultiUses, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "economical_2"), spell -> spell instanceof IHasMultiUses, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "economical_3"), spell -> spell instanceof IHasMultiUses, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "economical_4"), spell -> spell instanceof IHasMultiUses, true);
        new Modifier(new ResourceLocation("schoolsofmagic", "wasteful_1"), spell -> spell instanceof IHasMultiUses, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "wasteful_2"), spell -> spell instanceof IHasMultiUses, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "wasteful_3"), spell -> spell instanceof IHasMultiUses, false);
        new Modifier(new ResourceLocation("schoolsofmagic", "wasteful_4"), spell -> spell instanceof IHasMultiUses, false);
        for (MagicElement element : MagicElementRegistry.ELEMENTS) {
            new Modifier(new ResourceLocation("schoolsofmagic", element.getName()), spell -> spell instanceof IHasAdjustableElements && ((IHasAdjustableElements)((Object)spell)).isAcceptableElement(element), true);
        }
    }

    public static Spell getDefaultSpell(String name) {
        for (Spell spell : SPELLS) {
            if (!spell.getResourceLocation().toString().equals(name)) continue;
            return spell;
        }
        return null;
    }
}

