/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.registries;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import com.paleimitations.schoolsofmagic.common.registries.TeaRegistry;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;

public class TeaIngredientRegistry {
    public static List<TeaIngredient> INGREDIENTS = Lists.newArrayList();

    public static void register() {
        INGREDIENTS.add(new TeaIngredient(TeaRegistry.getTea("allium"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemRegistry.CRUSHED_ALLIUM.get()})));
        INGREDIENTS.add(new TeaIngredient(TeaRegistry.getTea("blue_orchid"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemRegistry.CRUSHED_BLUE_ORCHID.get()})));
        INGREDIENTS.add(new TeaIngredient(TeaRegistry.getTea("cornflower"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemRegistry.CRUSHED_CORNFLOWER.get()})));
        INGREDIENTS.add(new TeaIngredient(TeaRegistry.getTea("dandelion"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemRegistry.CRUSHED_DANDELION.get()})));
        INGREDIENTS.add(new TeaIngredient(TeaRegistry.getTea("lilly_of_the_valley"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemRegistry.CRUSHED_LILY_OF_THE_VALLY.get()})));
        INGREDIENTS.add(new TeaIngredient(TeaRegistry.getTea("poppy_seed"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemRegistry.POPPY_SEEDS.get()})));
        INGREDIENTS.add(new TeaIngredient(TeaRegistry.getTea("cocoa_bean"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196130_bo})));
        INGREDIENTS.add(new TeaIngredient(TeaRegistry.getTea("sugar"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151102_aT})));
    }

    public static TeaIngredient getIngredient(ItemStack stack) {
        for (TeaIngredient ingredient : INGREDIENTS) {
            if (!ingredient.isIngredient(stack)) continue;
            return ingredient;
        }
        return null;
    }

    public static TeaIngredient getIngredient(String name) {
        for (TeaIngredient ingredient : INGREDIENTS) {
            if (!ingredient.tea.name.equalsIgnoreCase(name)) continue;
            return ingredient;
        }
        return null;
    }

    public static class TeaIngredient {
        public final TeaRegistry.Tea tea;
        public final Ingredient ingredient;

        public TeaIngredient(TeaRegistry.Tea tea, Ingredient ingredient) {
            this.tea = tea;
            this.ingredient = ingredient;
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public List<EffectInstance> getEffects() {
            return this.tea.effects;
        }

        public boolean isIngredient(ItemStack stack) {
            return this.ingredient.test(stack);
        }
    }
}

