/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.registries;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;

public class TeaRegistry {
    public static List<Tea> TEAS = Lists.newArrayList();

    public static void register() {
        TEAS.add(new Tea("allium", 8550019, new EffectInstance(Effects.field_76422_e, 600), new EffectInstance(Effects.field_76426_n, 600)));
        TEAS.add(new Tea("blue_orchid", 7508378, new EffectInstance(Effects.field_76431_k, 400), new EffectInstance(Effects.field_76443_y)));
        TEAS.add(new Tea("cornflower", 6197382, new EffectInstance(Effects.field_76438_s, 400), new EffectInstance(Effects.field_76430_j, 600)));
        TEAS.add(new Tea("dandelion", 13676379, new EffectInstance(Effects.field_76422_e, 600), new EffectInstance(Effects.field_76443_y)));
        TEAS.add(new Tea("lily_of_the_valley", 12567946, new EffectInstance(Effects.field_76426_n, 600), new EffectInstance(Effects.field_76436_u, 400)));
        TEAS.add(new Tea("poppy_seed", 10122850, new EffectInstance(Effects.field_76421_d, 400), new EffectInstance(Effects.field_76439_r, 600)));
        TEAS.add(new Tea("cocoa_bean", 6440734, new EffectInstance(Effects.field_76424_c, 600), new EffectInstance(Effects.field_76439_r, 600)));
        TEAS.add(new Tea("sugar", -1, new EffectInstance(Effects.field_76424_c, 600), new EffectInstance(Effects.field_76422_e, 600)));
    }

    public static Tea getTea(String name) {
        if (name == null) {
            return null;
        }
        for (Tea tea : TEAS) {
            if (!tea.name.equalsIgnoreCase(name)) continue;
            return tea;
        }
        return null;
    }

    public static class Tea {
        public final String name;
        public final int color;
        public final List<EffectInstance> effects = Lists.newArrayList();

        public Tea(String name, int color, EffectInstance ... effects) {
            this.name = name;
            this.color = color;
            this.effects.addAll(Arrays.asList(effects));
        }

        public List<EffectInstance> getEffects() {
            return this.effects;
        }
    }
}

